@props([
    'classWiseSeries',
    'genderSeries',
    'examGradeSeries',
    'examName'
])

<div class="col-md-4 mb-3">
    <div class="chart__dash pi">
        <div id="class-wise-student" style="height: 320px"></div>
    </div>
</div>

<div class="col-md-4 mb-3">
    <div class="chart__dash pi">
        <div id="student-gender-pie" style="height: 320px"></div>
    </div>
</div>

<div class="col-md-4 mb-3">
    <div class="chart__dash pi">
        <div class="row">
            <div class="col-md-12">
                <div class="float-right">
                    <select name="exam_id" id="exam_id" class="form-control">
                        @foreach ($exams as $exam)
                            <option value="{{ $exam->id }}"
                                @selected(
                                    getCurrentActiveExamId() == $exam->id ||
                                    (!getCurrentActiveExamId() && $loop->first)
                                )
                                >
                                {{ $exam->exam_name }} {{ $exam->academic_year?->year }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
        <div id="last-exam-grade-chart" style="height: 320px"></div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {

    let examGradeChart = null;

    function renderPieChart(container, title, seriesData) {
        return Highcharts.chart(container, {
            chart: { type: 'pie' },
            title: { text: title },
            credits: { enabled: false },
            tooltip: {
                pointFormat: '<b>{point.percentage:.1f}%</b> ({point.y} students)'
            },
            plotOptions: {
                pie: {
                    dataLabels: {
                        enabled: true,
                        format: '{point.name}: {point.y}'
                    }
                }
            },
            series: [{
                name: 'Students',
                colorByPoint: true,
                data: seriesData
            }]
        });
    }

    // Static charts
    renderPieChart('class-wise-student', 'Class Wise Report', @json($classWiseSeries));
    renderPieChart('student-gender-pie', 'Boys vs Girls', @json($genderSeries));

    // Initial exam chart
    examGradeChart = renderPieChart(
        'last-exam-grade-chart',
        @json($examName),
        @json($examGradeSeries)
    );

    // 🔁 Exam change → AJAX update
    $('#exam_id').on('change', function () {
        let examId = $(this).val();

        $.get("{{ route('dashboard.exam.grade.chart') }}", {
            exam_id: examId
        }, function (response) {
            console.log(response);
            
            examGradeChart.setTitle({ text: response.examName });
            examGradeChart.series[0].setData(response.series);

        });
    });

});
</script>


<script>
// document.addEventListener('DOMContentLoaded', function () {
//     function renderPieChart(container, title, seriesData) {
//         Highcharts.chart(container, {
//             chart: {
//                 type: 'pie'
//             },
//             title: {
//                 text: title
//             },
//             credits: {
//                 enabled: false
//             },
//             tooltip: {
//                 pointFormat: '<b>{point.percentage:.1f}%</b> ({point.y} students)'
//             },
//             accessibility: {
//                 point: {
//                     valueSuffix: '%'
//                 }
//             },
//             plotOptions: {
//                 pie: {
//                     allowPointSelect: true,
//                     cursor: 'pointer',
//                     dataLabels: {
//                         enabled: true,
//                         format: '{point.name}: {point.y}'
//                     }
//                 }
//             },
//             series: [{
//                 name: 'Students',
//                 colorByPoint: true,
//                 data: seriesData
//             }]
//         });
//     }

//     // Class-wise students
//     renderPieChart(
//         'class-wise-student',
//         'Class Wise Report',
//         @json($classWiseSeries)
//     );

//     // Gender wise
//     renderPieChart(
//         'student-gender-pie',
//         'Boys vs Girls',
//         @json($genderSeries)
//     );

//     // Last exam grade
//     renderPieChart(
//         'last-exam-grade-chart',
//         @json($examName),
//         @json($examGradeSeries)
//     );
// });
</script>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script src="https://code.highcharts.com/highcharts.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">
@endpush


 <div class="heading"><span>Breaking:</span></div>