@props(['students'])
<div class="row">
    <div class="col-xl-12 col-lg-12 mb-4">
        <div class="card">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">Student List</h6>
                <a class="m-0 float-right btn btn-danger btn-sm" href="#">View More <i class="fas fa-chevron-right"></i></a>
            </div>
            <div class="table-responsive">
                <table class="table align-items-center table-flush">
                    <thead class="thead-light">
                        <tr>
                            <th>Student ID</th>
                            <th>Image</th>
                            <th>Name</th>
                            <th>Class</th>
                            <th>Section</th>
                            <th>Shift</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                        @foreach ($students as $student)
                            <tr>
                                <td><a href="">{{ $student->student_id_no }}</a></td>
                                <td>
                                    <img src="{{asset("uploads/student/graduated_student.png")}}" class="rounded-circle border p-1" alt="" height="40px" width="40px">
                                </td>
                                <td>{{ $student->first_name." ".$student->last_name }}</td>
                                <td>{{ $student->studentClass?->class_name }}</td>
                                <td>{{ $student->section?->section_name }}</td>
                                <td>{{ $student->shift?->shift_name }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="card-footer"></div>
        </div>
    </div>
</div>