
<div class=" group-selector-wrapper {{ $col }}" id="groupSection" style="display: none;">
    @if($label)
        <label for="{{ $name }}" class="form-label">{{ ucwords(str_replace('_', ' ', $label)) }}  @if($required) <span class="text-danger">*</span> @endif </label>
    @endif
    <select name="{{ $name }}" id="{{ $name }}" class="form-control" @if($required) required @endif>
        <option value="">{{ $labelText ?? $label }} </option>
        @foreach($groups as $id => $name)
            <option value="{{ $id }}" {{ $selected == $id ? 'selected' : '' }}>
                {{ $name }}
            </option>
        @endforeach
    </select>
</div>



@push('scripts')
<script>
$(document).ready(function () {
    function toggleGroupSelector(classId) {
        if (['11', '12', '13', '14'].includes(classId)) {
            $('.group-selector-wrapper').show();
        } else {
            $('.group-selector-wrapper').hide();
        }
    }

    toggleGroupSelector($('.student_class_id').val());

    $('.student_class_id').on('change', function () {
        toggleGroupSelector($(this).val());
    });
});
</script>
@endpush
