@if($containerClass)<div class="{{ $containerClass }}">@endif
    <div class="{{ $groupClass }}">
        <label for="{{ $prefix }}division_id" class="{{ $labelClass }}">Division</label>
        <select class="{{ $selectClass }}" id="{{ $prefix }}division_id" name="{{ $prefix }}division_id">
            <option value="">Select Division</option>
            @foreach($divisions as $division)
                <option value="{{ $division->id }}" {{ $selectedDivision == $division->id ? 'selected' : '' }}>
                    {{ $division->name }}
                </option>
            @endforeach
        </select>
    </div>
    

    <div class="{{ $groupClass }}">
        <label for="{{ $prefix }}district_id" class="{{ $labelClass }}">District</label>

        <select class="{{ $selectClass }}" id="{{ $prefix }}district_id" name="{{ $prefix }}district_id">
            <option value="">Select District</option>
            @foreach($districts as $district)
                <option value="{{ $district->id }}" {{ $selectedDistrict == $district->id ? 'selected' : '' }}>
                    {{ $district->name }}
                </option>
            @endforeach
        </select>
{{-- 
        <select class="{{ $selectClass }}" id="{{ $prefix }}district_id" name="{{ $prefix }}district_id">
            <option value="">Select District</option>
        </select> --}}
    </div>

    <div class="{{ $groupClass }}">
        <label for="{{ $prefix }}upazila_id" class="{{ $labelClass }}">Upazila</label>
        <select class="{{ $selectClass }}" id="{{ $prefix }}upazila_id" name="{{ $prefix }}upazila_id">
            <option value="">Select Upazila</option>
        </select>
    </div>

    {{-- <div class="{{ $groupClass }}">
        <label for="{{ $prefix }}union_id" class="{{ $labelClass }}">Union</label>
        <select class="{{ $selectClass }}" id="{{ $prefix }}union_id" name="{{ $prefix }}union_id">
            <option value="">Select Union</option>
        </select>
    </div> --}}
@if($containerClass)</div>@endif

@push('scripts')
<script>
$(document).ready(function() {
    // Function to load dropdown options
    function loadDropdownOptions(url, targetDropdown, selectedId = null, params = {}) {
        $.ajax({
            url: url,
            type: 'GET',
            data: params,
            success: function(data) {
                let options = '<option value="">Select Option</option>';
                data.forEach(function(item) {
                    options += `<option value="${item.id}" ${selectedId == item.id ? 'selected' : ''}>${item.name}</option>`;
                });
                $(targetDropdown).html(options);
            }
        });
    }

    let divisionId = `{{$selectedDivision}}`;
    let districtId = `{{$selectedDistrict}}`;
    let upazilaId = `{{$selectedUpazila}}`;
    let unionId = `{{$selectedUnion}}`;

    if (divisionId) {
        loadDropdownOptions("{{ route('locations.districts') }}", '#{{ $prefix }}district_id', districtId, {
            division_id: divisionId
        });
    }

    if (districtId) {
        loadDropdownOptions("{{ route('locations.upazilas') }}", '#{{ $prefix }}upazila_id', upazilaId, {
            district_id: districtId
        });
    }
    
    if (upazilaId) {
        loadDropdownOptions("{{ route('locations.unions') }}", '#{{ $prefix }}union_id', unionId, {
            upazila_id: upazilaId
        });
    }

    // Division change event

    $('#{{ $prefix }}division_id').change(function() {
        const divisionId = $(this).val();
        if (divisionId) {
            loadDropdownOptions("{{ route('locations.districts') }}", '#{{ $prefix }}district_id', districtId, {
                division_id: divisionId
            });
            $('#{{ $prefix }}upazila_id').html('<option value="">Select Upazila</option>');
            $('#{{ $prefix }}union_id').html('<option value="">Select Union</option>');
        }
    });

    // District change event
    $('#{{ $prefix }}district_id').change(function() {
        const districtId = $(this).val();
        if (districtId) {
            loadDropdownOptions("{{ route('locations.upazilas') }}", '#{{ $prefix }}upazila_id', upazilaId, {
                district_id: districtId
            });
            $('#{{ $prefix }}union_id').html('<option value="">Select Union</option>');
        }
    });

    // Upazila change event
    $('#{{ $prefix }}upazila_id').change(function() {
        const upazilaId = $(this).val();
        if (upazilaId) {
            loadDropdownOptions("{{ route('locations.unions') }}", '#{{ $prefix }}union_id', unionId, {
                upazila_id: upazilaId
            });
        }
    });
});
</script>
@endpush 