<div class="modal fade" id="{{ $type }}Modal" tabindex="-1" role="dialog" aria-labelledby="modalLabel-{{ $type }}" aria-hidden="true">
    <div class="modal-dialog modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <form method="POST" action="{{ $id ? route("{$type}.update", $id) : route("{$type}.store") }}">
                @csrf
                @if ($id) @method('PUT') @endif
                
                    <div class="modal-header">
                        <h5 class="modal-title">{{ $title }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">&times;</button>
                    </div>
                    <div class="modal-body">
                        @if ($type === 'class')
                            <div class="form-group">
                                <label>Class Name</label>
                                <input type="text" name="class_name" class="form-control" value="{{ $data['class_name'] ?? '' }}">
                            </div>
                            <div class="form-group">
                                <label>Shift</label>
                                <select name="shift_id" class="form-control">
                                    @foreach($shifts as $shift)
                                        <option value="{{ $shift->id }}" {{ ($data['shift_id'] ?? '') == $shift->id ? 'selected' : '' }}>{{ $shift->shift_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        @elseif ($type === 'section')
                            <div class="form-group">
                                <label>Section Name</label>
                                <input type="text" name="section_name" class="form-control" value="{{ $data['section_name'] ?? '' }}">
                            </div>
                        @elseif ($type === 'group')
                            <div class="form-group">
                                <label>Group Name</label>
                                <input type="text" name="group_name" class="form-control" value="{{ $data['group_name'] ?? '' }}">
                            </div>
                            <div class="form-group">
                                <label>Status</label>
                                <select name="status" class="form-control">
                                    <option value="1" {{ ($data['status'] ?? 1) == 1 ? 'selected' : '' }}>Active</option>
                                    <option value="0" {{ ($data['status'] ?? 1) == 0 ? 'selected' : '' }}>Inactive</option>
                                </select>
                            </div>
                        @elseif ($type === 'department')
                            <div class="form-group">
                                <label>Department Name</label>
                                <input type="text" name="name" class="form-control" value="{{ $data['name'] ?? '' }}">
                            </div>
                        @elseif ($type === 'shift')
                            <div class="form-group">
                                <label>Shift Name</label>
                                <input type="text" name="shift_name" class="form-control" value="{{ $data['shift_name'] ?? '' }}">
                            </div>
                            <div class="form-group">
                                <label>Start Time</label>
                                <input type="time" name="start_time" class="form-control" value="{{ $data['start_time'] ?? '' }}">
                            </div>
                            <div class="form-group">
                                <label>End Time</label>
                                <input type="time" name="end_time" class="form-control" value="{{ $data['end_time'] ?? '' }}">
                            </div>
                        @endif
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                    
            </form>
        </div>
    </div>

</div>
