@props(['columns', 'print' => false, 'exportExcel' => false, 'exportPdf' => false])
<div id="loading-icon" style="display: none;">
    <img src="{{asset('assets/img/loading.gif')}}" alt="Loading..." />
</div>
<div class="m-0 float-right" id="column-panel-parent">
    @if($print)
    <a class="btn btn-secondary btn__export" id="print-btn" href="#" data-toggle="tooltip" title="Print">
        <i class="fas fa-print"></i>
    </a>
    @endif
    @if($exportExcel)
    <a class="btn btn-secondary btn__export" id="excel-btn" href="#" data-toggle="tooltip" title="Download as excel">
        <i class="fas fa-file-excel"></i>
    </a>
    @endif
    @if($exportPdf)
    <a class="btn btn-secondary btn__export" id="pdf-btn" href="#" data-toggle="tooltip" title="Download as PDF">
        <i class="fas fa-file-pdf"></i>
    </a>
    @endif
    @if(isset($columns))    
        <a class="btn btn-secondary btn__export" href="#" data-toggle="collapse" data-target="#column-toggle-panel">
            <i class="fas fa-columns"></i>
        </a>
    @endif
    @if(isset($columns))
        <div id="column-toggle-panel" class="collapse border rounded-bottom shadow">
            @foreach($columns as $index => $label)
                <div class="form-check">
                    <a class="toggle-vis" data-column="{{ $index }}">{{ $label }}</a>
                </div>
            @endforeach
            <button class="restorebutton">Restore Visibility</button>
        </div>
    @endif
</div>
