<div>
    <input type="text" id="hostel-room-search" name="room_no" value="" class="form-control hostel-room-details" placeholder="Search by Room No. Ex- 101">
    <input type="hidden" id="hostel-room-search-value" name="hostel_room_id" class="hostel_room_id" value="">
</div>
<style>
.ui-autocomplete {
    z-index: 1051; /* Bootstrap modal z-index is typically 1050 */
}
</style>
@push('scripts')
<script>
$(document).ready(function() {
    $("#hostel-room-search").autocomplete({
        source: function(request, response) {
            $.ajax({
                url: "{{ route('hostel-rooms.search') }}",
                data: {
                    room_no : request.term
                },
                success: function(data) {
                    response($.map(data, function(hostel_room) {
                        const label = `${hostel_room.hostel.name} -> ${hostel_room.hostel_floor.name} -> ${hostel_room.room_name} -> (Tk. ${Math.round(hostel_room.room_type.cost_per_bed)}) - ${hostel_room.no_of_bed}/${hostel_room.empty_beds}`;
                        const value = hostel_room.id;
                        console.log(label);
                        return {
                            label: label,
                            value: value
                        };
                    }));
                }
            });
        },
        minLength: 3,
        select: function(event, ui) {
            $('#hostel-room-search').val(ui.item.label);
            $('#hostel-room-search-value').val(ui.item.value);
            return false;
        },
        focus: function(event, ui) {
            $('#hostel-room-search').val(ui.item.label);
            return false;
        }
    });
});

</script>
@endpush
