<style>
.student-search-wrapper {
    position: relative;
    display: inline-block;
    width: 100%;
}
.clear-search-text {
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-50%);
    cursor: pointer;
    color: #999;
    font-size: 16px;
    display: none;
    z-index: 10;
}
</style>
<div class="student-search-wrapper">
    <input type="text" id="student-search" 
           value="{{ $student_name ?? '' }}" 
           class="form-control form-control-sm" 
           placeholder="Student ID or Mobile" 
           {{ $required ?? '' }} 
           autocomplete="off">
    <span id="clear-search-text" class="clear-search-text">&times;</span>
    <input type="hidden" id="student-search-value" name="student_id_no" value="{{ $student_id_no ?? '' }}">
</div>

{{-- <div>
    <input type="text" id="student-search" value="{{ $student_name ?? '' }}" class="form-control form-control-sm" placeholder="Student ID or Mobile" {{$required ?? ""}}>
    <input type="hidden" id="student-search-value" name="student_id_no" value="{{ $student_id_no ?? '' }}">
</div>  --}}

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    const input = document.getElementById('student-search');
    const clearIcon = document.getElementById('clear-search-text');

    // Show or hide clear icon based on input content
    function toggleClearIcon() {
        clearIcon.style.display = input.value ? 'block' : 'none';
    }

    input.addEventListener('input', toggleClearIcon);
    toggleClearIcon(); // Initialize on page load

    // Clear input when icon is clicked
    clearIcon.addEventListener('click', function () {
        input.value = '';
        document.getElementById('student-search-value').value = '';
        toggleClearIcon();
        input.focus();
    });
});


$(document).ready(function() {
    $("#student-search").autocomplete({
        source: function(request, response) {
            $.ajax({
                url: "{{ route('students.search') }}",
                data: {
                    query: request.term
                },
                success: function(data) {
                    response($.map(data, function(student) {
                        if (/^0/.test(request.term)) { // Check if mobile number starts with 0
                            return {
                                label: `${student.first_name} ${student.last_name} (${student.mobile_no})`,
                                value: student.student_id_no
                            };
                        } else { // Otherwise, assume it's an ID starting with 1-9

                            return {
                                label: `${student.first_name} ${student.last_name} (${student.student_id_no})`,
                                value: student.student_id_no
                            };
                        }
                    }));
                }
            });
        },
        minLength: 3,
        select: function(event, ui) {
            $('#student-search').val(ui.item.label);
            $('#student-search-value').val(ui.item.value);
            return false;

            // Append the student to the list with checkbox
            var studentId = ui.item.student_id_no;
            if (!selectedStudents.includes(studentId)) {
                selectedStudents.push(studentId);

                // Display selected student with a checkbox
                // $('#selected-students').append(
                //     `<div class="selected-student" data-id="${studentId}">
                //         <input type="checkbox" class="student-checkbox" data-id="${studentId}" checked>
                //         ${ui.item.full_name} (${ui.item.guardian_mobile})
                //         <button type="button" class="remove-student-btn" data-id="${studentId}">Remove</button>
                //     </div>`
                // );

                // Update the hidden input field
                $('#student-search-value').val(selectedStudents.join(','));

                // Clear the input field
                $('#student-search').val('');
            }

            return false; // Prevent default select behavior
        },
        focus: function(event, ui) {
            $('#student-search').val(ui.item.label);
            return false;
        }
    });

    $("#student-search").on('input', function() {
        if ($(this).val() === '') {
            $('#student-search-value').val('');
        }
    });
});
</script>
@endpush
