<!DOCTYPE html>
<html>
<head>
    <title>{{ $title }}</title>
    <style>
        .center {
            text-align: center;
        }

        .left {
            text-align: left;
        }

        .header {
            padding-top: 10px;
            padding-bottom: 10px;
            border-bottom: 1px solid #ccc;
            text-align: center;
        }
        .header .institute-name {
            padding: 0;
            margin: 0;
        }

        .header p {
            margin: 0;
            padding: 0;
        }

        .download-date {
            text-align: left;
            font-size: 15px;
            padding-top: 10px;
        }

        .main-table {
            width: 100%;
        }

        .main-table thead {
            background-color: #eaecf4;
            color: black;
            width: 100%;
        }

        .main-table thead tr th {
            text-transform: capitalize;
        }

        table.main-table {
            border-collapse: collapse;
        }

        table.main-table td,
        table.main-table th {
            border: 1px solid #e3e6f0;
            font-size: 14px;
            padding-left: 2px;
        }

        table.main-table thead tr th {
            margin-bottom: 5px;
            font-size: 14px;
        }

        table.main-table tbody tr td:last-child {
            text-transform: capitalize;
        }
    </style>
</head>
<body>
    @php
        $headings = array_values($columns);
        $columns = array_keys($columns);
    @endphp
    <div class="card">
        <div class="header" style="text-align: center;">
            <h2 style="text-align: center;">{{ $title }}</h2>
        </div>
        <table class="main-table">
            <thead>
                <tr>
                    @foreach($headings as $heading)
                        <th>{{ $heading }}</th>
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @foreach($data as $row)
                    <tr>
                        @foreach($columns as $column)
                            @if (strpos($row[$column], 'image') !== false || strpos($row[$column], 'picture') !== false || strpos($row[$column], 'upload') !== false)
                                <td>Image</td>
                            @else
                                <td>{{ $row[$column] ?? 'N/A' }}</td>
                            @endif
                        @endforeach
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</body>
</html>
