<!DOCTYPE html>
<html>
<head>
    <title>{{ $title }}</title>
    <style>
        .center {
            text-align: center;
        }
        .left {
            text-align: left;
        }
        .header {
            padding-top: 10px;
            padding-bottom: 10px;
            border-bottom: 1px solid #ccc;
            text-align: center;
        }
        .header img {
            width: auto;
            height: 70px;
            padding: .25rem !important;
        }
        .header .institute-name {
            padding: 0;
            margin: 0;
        }
        .header p {
            margin: 0;
            padding: 0;
        }
        .download-date {
            text-align: left;
            font-size: 15px;
            padding-top: 10px;
        }
        .main-table {
            width: 100%;
        }
        .main-table thead {
            background-color: #eaecf4;
            color: black;
            width: 100%;
        }
        .main-table thead tr th {
            text-transform: capitalize;
        }
        table.main-table {
            border-collapse: collapse;
        }
        table.main-table td,
        table.main-table th {
            border: 1px solid #e3e6f0;
            font-size: 14px;
            padding-left: 2px;
        }
        table.main-table thead tr th {
            margin-bottom: 5px;
            font-size: 14px;
        }
        table.main-table tbody tr td:last-child {
            text-transform: capitalize;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="header">
            @php
                $logo_path = get_setting_value(Settings::EXPORT_LOGO)
                    ? get_setting_value(Settings::EXPORT_LOGO)
                    : 'uploads/images/logo.png';
                $institute_name = get_setting_value(Settings::SCHOOL_NAME)
                    ? get_setting_value(Settings::SCHOOL_NAME)
                    : '';
            @endphp
            <img src="{{ asset($logo_path) }}">
            <h2 class="institute-name">{{ $institute_name ?? '' }}</h2>
            <p><strong>{{ $title ?? 'Report' }}</strong></p>
            {!! $subtitle ?? '' !!}
            <div class="download-date">
                Requisition Date: {{ date('d-m-Y') }}
            </div>
        </div>
        @php
            $headings = array_values($columns);
            $columns = array_keys($columns);
        @endphp
        <table class="main-table">
            <thead>
                <tr>
                    @foreach ($headings as $heading)
                        <th class="center">{{ $heading }}</th>
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @foreach ($data as $row)
                    <tr class="center">
                        @foreach ($columns as $column)
                            <td>
                                @if (strpos($row[$column], 'image') !== false || strpos($row[$column], 'picture') !== false || strpos($row[$column], 'upload') !== false)
                                    <img src="{{ public_path($row[$column]) }}" alt="{{ $row[$column] }}" style="width: 40px; height: 40px;">
                                @else
                                    {{ $row[$column] ?? 'N/A' }}
                                @endif
                            </td>
                        @endforeach
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</body>
</html>