@extends('layouts.master')
@section('content')

    <div class="tab__item">
        <div class="row">
            <div class="col-xl-12 col-xxl-8 m-auto">
                <div class="card mt-4">
                    <div class="card-body">
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#student-class-tab" role="tab">Class</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#section-tab" role="tab">Section</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#group-tab" role="tab">Group</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#shift-tab" role="tab">Shift</a>
                        </li>
                    </ul>


                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div id="student-class-tab"
                             class="tab-pane fade {{ request()->query('tab', 'student-class') === 'student-class' ? 'show active' : '' }}">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Class</h6>
                                <button class="btn btn-sm btn-light-blue" data-toggle="modal"
                                        data-target="#StudentClassStoreModal"
                                        data-type="section">Add New
                                </button>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-strip table-bordered">
                                    <thead class="thead-light">
                                    <tr>
                                        {{-- <th>Shift</th> --}}
                                        <th>Class</th>
                                        <th>Secton</th>
                                        <th>Class Teacher</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($studentClasses as $studentClass)
                                            <tr>
                                                <td>{{ $studentClass->class_name }}</td>

                                                {{-- Sections --}}
                                                <td>
                                                    @foreach ($studentClass->classSections as $classSection)
                                                        <span class="badge badge-primary">{{ $classSection?->section?->section_name }}</span>
                                                    @endforeach
                                                </td>

                                                {{-- Class Teachers --}}
                                                <td>
                                                    @foreach ($studentClass->classSections as $classSection)
                                                        <span class="badge badge-primary">{{ $classSection?->classTeacher?->name }}</span>
                                                    @endforeach
                                                </td>

                                                <td class="d-flex justify-content-start">
                                                    @can('academic.student-class.edit')
                                                        <button class="btn btn-sm btn-soft-info mx-1"
                                                            id="add-student-btn"
                                                            data-toggle="modal"
                                                            data-target="#StudentClassEditModal"
                                                            data-section-ids="{{ $studentClass->classSections->pluck('section_id')->implode(',') }}"
                                                            data-class-name="{{ $studentClass->class_name }}"
                                                            data-id="{{ $studentClass->id }}"
                                                        >
                                                            <i class="fas fa-edit"></i>
                                                        </button>
                                                    @endcan
                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div id="section-tab"
                             class="tab-pane fade {{ request()->query('tab') === 'section' ? 'show active' : '' }}">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Section</h6>
                                <div class="m-0 float-right">
                                    @can('academic.sections.create')
                                        <button class="btn btn-sm btn-light-blue" id="add-student-btn"
                                                data-toggle="modal" data-target="#SectionStoreModal">Add New
                                        </button>
                                    @endcan
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-strip">
                                    <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($sections as $key => $section)
                                        <tr>
                                            <td>{{ ++$key }}</td>
                                            <td>{{ $section->section_name }}</td>
                                            <td class="d-flex justify-content-start">
                                                @can('academic.sections.edit')
                                                    <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn"
                                                            data-toggle="modal"
                                                            data-target="#SectionEditModal"
                                                            data-name="{{ $section->section_name }}"
                                                            data-id="{{ $section->id }}"><i class="fas fa-edit"></i>
                                                    </button>
                                                @endcan
                                                @can('academic.sections.delete')
                                                    {{-- <a class="btn btn-sm btn-soft-danger"
                                                    onclick="return confirm('Are you sure you want to delete this')"
                                                    href="{{ route('sections.destroy', ['section' => $section->id]) }}"><i
                                                            class="fas fa-trash"></i></a> --}}
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div id="group-tab"
                             class="tab-pane fade {{ request()->query('tab') === 'group' ? 'show active' : '' }}">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Group</h6>
                                <div class="m-0 float-right">
                                    @can('academic.groups.create')
                                        <button class="btn btn-sm btn-light-blue" id="add-student-btn"
                                                data-toggle="modal" data-target="#GroupStoreModal">Add
                                            New
                                        </button>
                                    @endcan
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-strip">
                                    <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Status</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @if (!empty($groups))
                                        @foreach ($groups as $key => $group)
                                            <tr>
                                                <td>{{ ++$key }}</td>
                                                <td>{{ $group->group_name }}</td>
                                                <td>
                                                        <span
                                                            class="badge {{ $group->status == 1 ? 'badge-success' : 'badge-warning' }}">{{ $group->status == 1 ? 'Active' : 'In-Active' }}</span>
                                                </td>
                                                <td class="d-flex justify-content-start">
                                                    @can('academic.groups.edit')
                                                        <button class="btn btn-sm btn-soft-info mr-1"
                                                                id="add-student-btn" data-toggle="modal"
                                                                data-target="#GroupEditModal"
                                                                data-name="{{ $group->group_name }}"
                                                                data-status="{{ $group->status }}"
                                                                data-id="{{ $group->id }}"><i class="fas fa-edit"></i>
                                                        </button>
                                                    @endcan
                                                    @can('academic.groups.delete')
                                                        {{-- <form method="POST" action="{{ route('groups.destroy', $group->id) }}"
                                                            onsubmit="return confirm('Are you sure you want to delete this group?')">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                                        </form> --}}
                                                    @endcan

                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>


                        <div id="shift-tab"
                             class="tab-pane fade {{ request()->query('tab') === 'shift' ? 'show active' : '' }}">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Shift</h6>
                                <div class="m-0 float-right">
                                    @can('academic.shifts.create')
                                        <button class="btn btn-sm btn-light-blue" data-toggle="modal"
                                                data-target="#ShiftStoreModal"
                                                data-type="shift">Add New
                                        </button>
                                    @endcan
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-strip">
                                    <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Start Time</th>
                                        <th>End Time</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($shifts as $key => $shift)
                                        <tr>
                                            <td>{{ ++$key }}</td>
                                            <td>{{ $shift->shift_name }}</td>
                                            <td>{{ time_format($shift->start_time) }}</td>
                                            <td>{{ time_format($shift->end_time) }}</td>
                                            <td class="d-flex justify-content-start">
                                                @can('academic.shifts.edit')
                                                    <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn"
                                                            data-toggle="modal" data-target="#ShiftEditModal"
                                                            data-name="{{ $shift->shift_name }}"
                                                            data-start="{{ $shift->start_time }}"
                                                            data-end="{{ $shift->end_time }}"
                                                            data-id="{{ $shift->id }}"><i
                                                            class="fas fa-edit"></i></button>
                                                @endcan
                                                @can('academic.shifts.delete')
                                                    {{-- <a class="btn btn-sm btn-soft-danger"
                                                        onclick="return confirm('Are you sure you want to delete this')"
                                                        href="{{ route('shifts.destroy', ['shift' => $shift->id]) }}"><i
                                                            class="fas fa-trash"></i></a> --}}
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Section create Modal -->
    <div class="modal fade" id="SectionStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="{{ route('sections.store') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel1">Add Section </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="section_name">Section Name <span class="text-danger">*</span></label>
                            <input id="section_name" type="text" class="form-control" name="section_name"
                                   placeholder="Enter Section Name" required>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="SectionEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="{{ route('sections.update') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel2">Edit Section </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="section_name">Section Name <span class="text-danger">*</span></label>
                            <input id="section_name" type="text" class="form-control" name="section_name" required>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Section modal end -->

    <!-- Group create Modal -->
    <div class="modal fade" id="GroupStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="{{ route('groups.store') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel3">Add Group </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="group_name">Group Name <span class="text-danger">*</span></label>
                            <input id="group_name" type="text" class="form-control" name="group_name" required>
                        </div>
                        <div class="form-group">
                            <label for="status">Group Status <span class="text-danger">*</span></label>
                            <select name="status" id="status" class="form-control ">
                                <option value="1">Active</option>
                                <option value="0">In-Active</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="GroupEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="{{ route('groups.update') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel4">Edit Group </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="group_name">Group Name <span class="text-danger">*</span></label>
                            <input id="group_name" type="text" class="form-control" name="group_name" required>
                        </div>
                        <div class="form-group">
                            <label for="status">Group Status <span class="text-danger">*</span></label>
                            <select name="status" id="status" class="form-control ">
                                <option value="1">Active</option>
                                <option value="0">In-Active</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Grop modal end -->

    <!-- Department create Modal -->
    <div class="modal fade" id="DepartmentStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="{{ route('department.store') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel5">Add Department</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="inputName">Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" maxlength="250" id="inputName" name="name"
                                   required placeholder="Enter department"/>
                            <span class="text-danger">{{ $errors->has('name') ? $errors->first('name') : '' }}</span>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">

                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="DepartmentEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="{{ route('department.update') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel6">Edit Department</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="hidden" id="id" name="id">
                            <input type="text" class="form-control" maxlength="250" id="name" name="name"
                                   required placeholder="Enter department"/>
                            <span class="text-danger">{{ $errors->has('name') ? $errors->first('name') : '' }}</span>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Department modal end -->

    <!-- Shift create Modal -->
    <div class="modal fade" id="ShiftStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="{{ route('shifts.store') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel7">Add Shift </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="shift_name">Shift Name <span class="text-danger">*</span></label>
                            <input id="shift_name" type="text" class="form-control" name="shift_name" required>
                        </div>
                        <div class="form-group ">
                            <label for="start_time">Start Time <span class="text-danger">*</span></label>
                            <input id="start_time" type="time" class="form-control" name="start_time" required step="60">
                        </div>
                        <div class="form-group">
                            <label for="end_time">End Time <span class="text-danger">*</span></label>
                            <input id="end_time" type="time" class="form-control" name="end_time" required step="60">
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="ShiftEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="{{ route('shifts.update') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel8">Edit Shift </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="shift_name">Shift Name <span class="text-danger">*</span></label>
                            <input id="shift_name" type="text" class="form-control" name="shift_name" required>
                        </div>
                        <div class="form-group ">
                            <label for="start_time">Start Time <span class="text-danger">*</span></label>
                            <input id="start_time" type="time" class="form-control" name="start_time" required step="60">
                        </div>
                        <div class="form-group">
                            <label for="end_time">End Time <span class="text-danger">*</span></label>
                            <input id="end_time" type="time" class="form-control" name="end_time" required step="60">
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!--Shift modal end -->

    <!-- student class create Modal -->
    <div class="modal fade" id="StudentClassStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="{{ route('student_class.store') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel9">Add Class </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>

                        {{-- <div class="form-group">
                            <label for="class_name">Shift </label>
                            {{ generateDropdown($shifts, 'class="form-control" name="shift_id" ', old('shift_id'), 'Select Option') }}
                        </div> --}}

                        <div class="form-group">
                            <label for="class_name">Class Name <span class="text-danger">*</span></label>
                            <input id="class_name" type="text"
                                   class="form-control @error('class_name') is-invalid @enderror" name="class_name"
                                   value="{{ old('class_name') }}" placeholder="Enter class name" required>
                        </div>

                        <div class="form-group">
                            <label>Sections</label>
                            @foreach ($sections as $section)
                                <div class="custom-control custom-checkbox mb-2">
                                    <input type="checkbox" class="custom-control-input" id="section{{ $section->id }}"
                                           name="sections[]" value="{{ $section->id }}">
                                    <label class="custom-control-label"
                                           for="section{{ $section->id }}">{{ $section->section_name }}</label>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="StudentClassEditModal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="{{ route('student_class.update') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel10">Edit Class </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="class_name_edit">Class Name <span class="text-danger">*</span></label>
                            <input id="class_name_edit" type="text"
                                   class="form-control @error('class_name') is-invalid @enderror" name="class_name"
                                   value="{{ old('class_name') }}" placeholder="Enter class name" required>
                        </div>

                        <div class="form-group">
                            <label>Sections</label>
                            @foreach ($sections as $key=>$section)
                                <div class="custom-control custom-checkbox mb-2">
                                    <input type="checkbox" class="custom-control-input" id="section-edit{{ $section->id }}"
                                           name="sections[]" value="{{ $section->id }}">
                                    <label class="custom-control-label"
                                           for="section-edit{{ $section->id }}">{{ $section->section_name }}</label>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- student class modal end -->
@stop
@section('scripts')
    <script type="text/javascript">

        // Save active tab on click
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            localStorage.setItem('activeTab', $(e.target).attr('href'));
        });

        // Load active tab on page reload
        $(document).ready(function () {
            var activeTab = localStorage.getItem('activeTab');
            if (activeTab) {
                $('a[href="' + activeTab + '"]').tab('show');
            }
        });

        // SectionEditModal
        $('#SectionEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var name = button.data('name')
            var studentClass = button.data('student-class')
            var id = button.data('id')
            console.log(studentClass)
            var modal = $(this)
            modal.find('#section_name').val(name)
            modal.find("#student_class option[value=" + studentClass + "]").prop("selected", true);
            modal.find('#id').val(id)
        })
        // GroupEditModal
        $('#GroupEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var name = button.data('name')
            var status = button.data('status')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#group_name').val(name)
            modal.find("#status option[value=" + status + "]").prop("selected", true);
            modal.find('#id').val(id)
        })
        // DepartmentEditModal
        $('#DepartmentEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget) // Button that triggered the modal
            var name = button.data('name')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#name').val(name)
            modal.find('#id').val(id)
        })
        // ShiftEditModal
        $('#ShiftEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var name = button.data('name')
            var start = button.data('start')
            var end = button.data('end')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#shift_name').val(name)
            modal.find('#start_time').val(start)
            modal.find('#end_time').val(end)
            modal.find('#id').val(id)
        })
        // StudentClassEditModal
        $('#StudentClassEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var className = button.data('class-name')
            var sectionIds = button.data('section-ids')
            console.log(sectionIds);
            var id = button.data('id')
            var modal = $(this)
            modal.find('#class_name_edit').val(className)
            modal.find('#id').val(id)
            // 1. Clear all checkboxes first
            modal.find('input[name="sections[]"]').prop('checked', false);
            if (sectionIds) {
                var ids = sectionIds.toString().split(','); 

                // 3. Loop and check them
                ids.forEach(function (sid) {
                    modal.find('#section-edit' + sid.trim()).prop('checked', true);
                });
            }

        })
    </script>
@endsection
