@extends('layouts.master')
@section('content')



    <div class="row">
        <div class="col-xl-12 col-xxl-8 m-auto">
            <div class="card mt-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 table__top__txt">Branch List</h6>
                    <div class="m-0 float-right">
                        @can('academic.branches.create')
                            <button class="btn btn-sm btn-light-blue" id="add-student-btn"
                                    data-toggle="modal" data-target="#dataStoreModal">Add New
                            </button>
                        @endcan
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Address</th>
                                    <th>Contact Info</th>
                                    <th>Status</th>
                                    <th class="action__col">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if($branches->isNotEmpty())
                                    @foreach ($branches as $branch)
                                        <tr>
                                            <td>{{ $branch->id }}</td>
                                            <td>{{ $branch->branch_name }}</td>
                                            <td>{{ $branch->address }}</td>
                                            <td>{{ $branch->contact_info }}</td>
                                            <td>{!! getStatus($branch->status) !!}</td>
                                            <td class="">
                                                @can('academic.branches.edit')
                                                    <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn"
                                                            data-toggle="modal"
                                                            data-target="#dataEditModal"
                                                            data-name="{{ $branch->branch_name }}"
                                                            data-address="{{ $branch->address }}"
                                                            data-contact="{{ $branch->contact_info }}"
                                                            data-status="{{ $branch->status }}"
                                                            data-id="{{ $branch->id }}"><i class="fas fa-edit"></i>
                                                    </button>
                                                @endcan
                                                @can('academic.branches.delete')
                                                    <form action="{{ route('branches.destroy', $branch->id) }}"
                                                          method="POST"
                                                          class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-soft-danger btn-sm"
                                                                onclick="return confirm('Are you sure you want to delete this branch?')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="6" class="text-center">No data available in table</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- create Modal -->
    <div class="modal fade" id="dataStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('branches.store') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Branch </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="branch_name">Branch Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="branch_name" name="branch_name"
                                   placeholder="Enter Branch Name" required>
                        </div>
                        <div class="form-group">
                            <label for="address">Address <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="address" name="address"
                                   placeholder="Enter branch address" required>
                        </div>
                        <div class="form-group">
                            <label for="contact_info">Contact Info <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="contact_info" name="contact_info"
                                   placeholder="Enter contact info" required>
                        </div>
                        <div class="form-group">
                            <label for="status">Status <span class="text-danger">*</span></label>
                            <select type="text" class="form-control" id="status" name="status" required>
                                <option value='1'>Active</option>
                                <option value='0'>Inactive</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->

    <!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('branches.update') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Branch </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="branch_name">Branch Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="branch_name" name="branch_name"
                                   placeholder="Enter Branch Name" required>
                        </div>
                        <div class="form-group">
                            <label for="address">Address <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="address" name="address"
                                   placeholder="Enter branch address" required>
                        </div>
                        <div class="form-group">
                            <label for="contact_info">Contact Info <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="contact_info" name="contact_info"
                                   placeholder="Enter contact info" required>
                        </div>
                        <div class="form-group">
                            <label for="status">Status <span class="text-danger">*</span></label>
                            <select type="text" class="form-control" id="status" name="status" required>
                                <option value='1'>Active</option>
                                <option value='0'>Inactive</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    <!-- modal end -->
@stop
@section('scripts')
    <script type="text/javascript">
        $('#dataEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var name = button.data('name')
            var address = button.data('address')
            var contact = button.data('contact')
            var status = button.data('status')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#branch_name').val(name)
            modal.find('#address').val(address)
            modal.find('#contact_info').val(contact)
            modal.find("#status option[value=" + status + "]").prop("selected", true);
            modal.find('#id').val(id)
        })
    </script>
@endsection
