@extends('layouts.master')
@section('content')
    <div class="row">
        <div class="col-md-10 col-lg-10 col-xl-12 col-xxl-8 m-auto">
            <div class="card mt-4" id="print-layout">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 table__top__txt">Building List</h6>
                    <div class="m-0 float-right">
                        <button class="btn btn-sm btn-light-blue"
                            data-toggle="modal" data-target="#dataStoreModal">Add New
                        </button>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table table-strip">
                                <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Branch</th>
                                    <th>Building</th>
                                    <th class="action__col">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @php
                                    $sn = 0;
                                @endphp
                                @foreach ($buildings as $building)
                                    <tr>
                                        <td>{{ ++$sn }}</td>
                                        <td>{{ $building->branch->branch_name }}</td>
                                        <td>{{ $building->building_name }}</td>
                                        <td class="d-flex justify-content-start">
                                            <button class="btn btn-sm btn-soft-info mr-1"
                                                    data-toggle="modal"
                                                    data-target="#dataEditModal"
                                                    data-branch="{{ $building->branch->id }}"
                                                    data-building="{{ $building->building_name }}"
                                                    data-id="{{ $building->id }}"><i class="fas fa-edit"></i>
                                            </button>
                                            <form action="{{ route('buildings.destroy', $building->id) }}" method="POST"
                                                  class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-soft-danger btn-sm"
                                                    onclick="return confirm('Are you sure you want to delete this branch?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- create Modal -->
    <div class="modal fade" id="dataStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form method="POST" action="{{ route('buildings.store') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Building</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="building_name">Building Name <span class="text-danger">*</span></label>
                            <input id="building_name" type="text"
                                class="form-control @error('building_name') is-invalid @enderror"
                                name="building_name"
                                autocomplete="building_name" autofocus required>
                        </div>
                        <div class="form-group">
                            <label for="provost">Select Branch <span class="text-danger">*</span></label>
                            {{ generateDropdown($branches, 'class="form-control select2" name="branch_id" required') }}
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->
    <!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('buildings.update') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Building</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="building_name">Building Name <span class="text-danger">*</span></label>
                            <input id="building_name" type="text"
                                class="form-control @error('building_name') is-invalid @enderror"
                                name="building_name"
                                autocomplete="building_name" autofocus required>
                        </div>
                        <div class="form-group">
                            <label for="branch_name">Select Branch <span class="text-danger">*</span></label>
                            {{ generateDropdown($branches, 'class="form-control select2 branch_name" id="branch_name" name="branch_id" required') }}
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->
@stop
@section('scripts')
    <script type="text/javascript">
        $('#dataEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var branch_name = button.data('branch')
            var building_name = button.data('building')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#building_name').val(building_name)
            modal.find("#branch_name").val(branch_name).trigger('change');
            modal.find('#id').val(id)
        })
    </script>
@endsection
