@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-lg-8 m-auto">
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card mt-4" id="print-layout">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Building Floor List</h6>
                <div class="m-0 float-right">
                    <button class="btn btn-sm btn-primary"
                        data-toggle="modal" data-target="#dataStoreModal">Add New
                    </button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table table-strip">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Building Name</th>
                                    <th>Floor Number</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($buildingFloors as $buildingFloor)
                                    <tr>
                                        <td>{{ $buildingFloor->id }}</td>
                                        <td>{{ $buildingFloor->building->building_name }}</td>
                                        <td>{{ $buildingFloor->floor_number }}</td>
                                        <td class="d-flex justify-content-start">
                                            <button class="btn btn-sm btn-soft-info mr-1"
                                                    data-toggle="modal"
                                                    data-target="#dataEditModal"
                                                    data-building-id="{{ $buildingFloor->building->id  }}"
                                                    data-floor="{{ $buildingFloor->floor_number }}"
                                                    data-id="{{ $buildingFloor->id }}"><i class="fas fa-edit"></i>
                                            </button>
                                            <form action="{{ route('building_floors.destroy', $buildingFloor->id) }}" method="POST" style="display: inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure you want to delete this building floor?')"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
    <!-- create Modal -->
    <div class="modal fade" id="dataStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form method="POST" action="{{ route('building_floors.store') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Building Floor</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="building_id">Building <span class="text-danger">*</span></label>
                            {{ generateDropdown($buildings, 'class="form-control" name="building_id" required') }}
                        </div>
                        <div class="form-group">
                            <label for="floor_number">Floor Number <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="floor_number" name="floor_number" required>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary submitBtn">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->
    <!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('building_floors.update') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Building Floor</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="building_id">Building <span class="text-danger">*</span></label>
                            {{ generateDropdown($buildings, 'class="form-control" id="building-id" name="building_id" required') }}
                        </div>
                        <div class="form-group">
                            <label for="floor_number">Floor Number <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="floor_number" name="floor_number" required>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary submitBtn">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->
@stop
@section('scripts')
    <script type="text/javascript">
        $('#dataEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var building_id = button.data('building-id')
            var floor_number = button.data('floor')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#floor_number').val(floor_number)
            modal.find("#building-id").val(building_id).trigger('change');
            modal.find('#id').val(id)
        })
    </script>
@endsection
