@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-lg-8 m-auto">
        <div class="card mt-4" id="print-layout">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Class Room List</h6>
                <div class="m-0 float-right">
                    <button class="btn btn-sm btn-light-blue"
                        data-toggle="modal" data-target="#dataStoreModal">Add New
                    </button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table table-strip">
                            <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Room No</th>
                                        <th>Building</th>
                                        <th>Floor</th>
                                        <th>Total Seat</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($class_rooms as $room)
                                    <tr>
                                        <td>{{ $room->id }}</td>
                                        <td>{{ $room->room_no }}</td>
                                        <td>{{ $room->buildingFloor->building->building_name }}</td>
                                        <td>{{ $room->buildingFloor->floor_number }}</td>
                                        <td>{{ $room->total_seat }}</td>
                                        <td class="d-flex justify-content-start">
                                            <button class="btn btn-sm btn-soft-info mr-1"
                                                    data-toggle="modal"
                                                    data-target="#dataEditModal"
                                                    data-room="{{ $room->room_no }}"
                                                    data-building="{{ $room->buildingFloor->building->id }}"
                                                    data-floor="{{ $room->buildingFloor->id }}"
                                                    data-seat="{{ $room->total_seat }}"
                                                    data-id="{{ $room->id }}"><i class="fas fa-edit"></i>
                                            </button>
                                            <a class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure you want to delete this')" href="{{route('class_rooms.destroy',['class_room'=>$room->id])}}"><i class="fas fa-trash"></i></a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- create Modal -->
<div class="modal fade" id="dataStoreModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form method="POST" action="{{ route('class_rooms.store') }}">
            @csrf
            <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel">Add Class Room</h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <p class="statusMsg"></p>
                    <div class="form-group">
                        <label for="room_no">Room No <span class="text-danger">*</span></label>
                        <input id="room_no" type="text" class="form-control" name="room_no" placeholder="Enter room no" required>
                    </div>
                    <div class="form-group">
                        <label for="building_id">Building <span class="text-danger">*</span></label>
                        {{ generateDropdown($buildings, 'class="form-control select2" name="building_id" required') }}
                    </div>
                    <div class="form-group">
                        <label for="building_floor_id">Floor No <span class="text-danger">*</span></label>
                        {{ generateDropdown($floors, 'class="form-control select2" name="building_floor_id" required') }}
                    </div>
                    <div class="form-group">
                        <label for="total_seat">Total Seat <span class="text-danger">*</span></label>
                        <input id="total_seat" type="number" class="form-control" name="total_seat" min="0" placeholder="Enter total seat" required>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->
<!--edit Modal -->
<div class="modal fade" id="dataEditModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id='myForm' method="POST" action="{{ route('class_rooms.update') }}">
            @csrf
            <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel">Edit Class Room</h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <p class="statusMsg"></p>
                    <input type="hidden" id="id" name="id">
                    <div class="form-group">
                        <label for="room_no">Room No <span class="text-danger">*</span></label>
                        <input id="room_no" type="text" class="form-control" name="room_no" placeholder="Enter room no" required>
                    </div>
                    <div class="form-group">
                        <label for="building_id">Building <span class="text-danger">*</span></label>
                        {{ generateDropdown($buildings, 'class="form-control select2" id="building_id" name="building_id" required') }}
                    </div>
                    <div class="form-group">
                        <label for="building_floor_id">Floor No <span class="text-danger">*</span></label>
                        {{ generateDropdown($floors, 'class="form-control select2" id="building_floor_id" name="building_floor_id" required') }}
                    </div>
                    <div class="form-group">
                        <label for="total_seat">Total Seat <span class="text-danger">*</span></label>
                        <input id="total_seat" type="number" class="form-control" name="total_seat" min="0" placeholder="Enter total seat" required>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->
@stop
@section('scripts')
    <script type="text/javascript">
        $('#dataEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var room_no = button.data('room')
            var building = button.data('building')
            var floor = button.data('floor')
            var seat = button.data('seat')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#room_no').val(room_no)
            modal.find('#total_seat').val(seat)
            modal.find("#building_id").val(building).trigger('change');
            modal.find("#building_floor_id").val(floor).trigger('change');
            modal.find('#id').val(id)
        })
    </script>
@endsection
