@extends('layouts.master')
@section('content')
    <div class="card mt-4">
        <div class="card-header py-3 card__head">
            <form action="{{ route('class-routine.create') }}" method="GET">
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            {{ generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id" required', request()->query('shift_id'), 'Select Shift') }}
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            {{ generateDropdown($studentClasses, 'class="form-control student_class" id="student_class" name="student_class" required', request()->query('student_class'), "Select Class") }}
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            {{ generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id"', request()->query('section_id'), 'Select Section') }}
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', request()->query('group_id'), 'Select Group') }}
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (isset($assignedSubjects) && !empty($assignedSubjects))
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
                <h6 class="m-0 table__top__txt">Create Routine</h6>
                <div class="m-0 float-right">
                    <a href="{{ route('class-routine.index') }}" class="btn btn-sm btn-light-blue">View All</a>
                </div>
            </div>
            <div class="card-body">
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif

                <form class="routine-form" method="POST" action="{{ route('class-routine.store') }}">
                    @csrf

                    <input type="hidden" name="shift_id" value="{{ request()->query('shift_id') }}">
                    <input type="hidden" name="student_class_id" value="{{ request()->query('student_class') }}">
                    <input type="hidden" name="section_id" value="{{ request()->query('section_id') }}">

                    @foreach(['Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday'] as $day)
                        <h3>{{ $day }}</h3>
                        <input type="hidden" name="days[]" value="{{ $day }}">
                        <div class="table-responsive py-3">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Action</th>
                                        <th>Subject</th>
                                        <th>Teacher</th>
                                        <th>Start Time</th>
                                        <th>End Time</th>
                                        <th>Room No</th>
                                    </tr>
                                </thead>
                                <tbody class="day-schedule">
                                    <tr class="subject-entry">
                                        <td>
                                            <button type="button" class="btn btn-danger remove-subject px-2 py-0"><i class="fas fa-minus-circle"></i></button>
                                        </td>
                                        <td>
                                            <select name="subjects[{{ strtolower($day) }}][0][subject]" class="form-control">
                                                <option value="">Select Subject</option>
                                                @foreach ($assignedSubjects as $assignedSubject)
                                                    <option value="{{ $assignedSubject->subject->id }}">{{ $assignedSubject->subject->subject_name }}</option>
                                                @endforeach
                                            </select>
                                        </td>
                                        <td>
                                            {{ generateDropdown($teachers, 'class="form-control select2" name="subjects[' . strtolower($day) . '][0][teacher]"', '', "Select Teacher") }}
                                        </td>
                                        <td>
                                            <input type="time" class="form-control" name="subjects[{{ strtolower($day) }}][0][start_time]" >
                                        </td>
                                        <td>
                                            <input type="time" class="form-control" name="subjects[{{ strtolower($day) }}][0][end_time]" >
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" name="subjects[{{ strtolower($day) }}][0][room_no]" placeholder="Room No" >
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <button type="button" class="btn btn-success add-subject my-3 px-2 py-1" data-day="{{ strtolower($day) }}"><i class="fas fa-plus-circle"></i> Add</button>
                        </div>
                    @endforeach

                    <div class="flex d-flex justify-content-end">
                        <a href="{{ route('class-routine.index') }}" type="submit" class="btn btn-default mt-3 mr-3">Discard</a>
                        <button type="submit" class="btn btn-submit mt-3">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    @endif

@endsection
@section('scripts')
    <script>

        $(document).ready(function() {

            $('.student_class').on('change', function(){
                let student_class_id =  $(this).val();
                if(student_class_id){
                    getSectionData(student_class_id);
                }

            });

            let student_class_id = "{{ request()->query('student_class') }}";
            if(student_class_id){

                getSectionData(student_class_id)
            }

            function getSectionData(student_class_id){
                if(student_class_id){
                    $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                        let sections = response;
                        let section_id = "{{ request()->query('section_id') }}";
                        let option = '<option value="">--Select Section--</option>';
                        for(let i=0;i<sections.length;i++){

                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }
                        }
                        $('select.section_id').empty().append(option);
                    });
                }
            }
            // Add new subject entry
            $('.add-subject').click(function() {
                const day = $(this).data('day');
                const tbody = $(this).closest('div.table-responsive.py-3').find('tbody.day-schedule'); // Get the closest table

                const index = tbody.find('.subject-entry').length;
                console.log("Number of subject entries:", index); // Log the count of subject entries

                if (tbody.length === 0) {
                    console.error("No tbody found! Check the HTML structure.");
                    return; // Exit if tbody is not found
                }
                const newSubjectEntry = `
                    <tr class="subject-entry">
                        <td>
                            <button type="button" class="btn btn-danger remove-subject px-2 py-0"><i class="fas fa-minus-circle"></i></button>
                        </td>
                        <td>
                            <select name="subjects[${day}][${index}][subject]" class="form-control">
                                @foreach ($assignedSubjects as $assignedSubject)
                                    <option value="{{ $assignedSubject->subject->id }}">{{ $assignedSubject->subject->subject_name }}</option>
                                @endforeach
                            </select>
                        </td>
                        <td>
                            {{ generateDropdown($teachers, 'class="form-control select2" name="subjects[${day}][${index}][teacher]"', '', "Select Teacher") }}
                        </td>
                        <td>
                            <input type="time" class="form-control" name="subjects[${day}][${index}][start_time]" required>
                        </td>
                        <td>
                            <input type="time" class="form-control" name="subjects[${day}][${index}][end_time]" required>
                        </td>
                        <td>
                            <input type="text" class="form-control" name="subjects[${day}][${index}][room_no]" placeholder="Room No" required>
                        </td>
                    </tr>
                `;

                tbody.append(newSubjectEntry);
            });

            // Remove subject entry
            $(document).on('click', '.remove-subject', function() {
                $(this).closest('.subject-entry').remove();
            });
        });

    </script>
@endsection
