@extends('layouts.master')
@section('content')
<div class="card mt-4" id="print-layout">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Class Routine List</h6>
        <div class="m-0 float-right">
            <a class="btn btn-sm btn-light-blue" href="{{ route('class-routine.create') }}">Add New</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table table-strip">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Shift</th>
                            <th>Class</th>
                            <th>Section</th>
                            <th class="action__col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $sn = 0;
                        @endphp
                        @foreach ($classRoutines as $routine)
                            <tr>
                                <td>{{ ++$sn; }}</td>
                                <td>{{ $routine->shift->shift_name ?? 'N/A'}}</td>
                                <td>{{ $routine->studentClass->class_name ?? '' }}</td>
                                <td>{{ $routine->section->section_name ?? 'N/A' }}</td>
                                <td class="d-flex justify-content-start">
                                    @if (!empty($routine->id))
                                        @can('academic.class-routine.view')
                                            <a href="{{ route('class-routine.show', $routine->id) }}"
                                                class="btn btn-soft-success btn-sm"><i class="fas fa-eye"></i></a>
                                        @endcan
                                        @can('academic.class-routine.edit')
                                            <a href="{{ route('class-routine.edit', $routine->id) }}"
                                                class="btn btn-soft-info btn-sm mx-1"><i class="fas fa-edit"></i></a>
                                        @endcan
                                        @can('academic.class-routine.delete')
                                            <form action="{{ route('class-routine.destroy', $routine->id) }}" method="POST"
                                                class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-soft-danger btn-sm"
                                                    onclick="return confirm('Are you sure you want to delete this class time period?')"><i class="fas fa-trash"></i></button>
                                            </form>
                                        @endcan
                                    @else
                                        <a class="btn btn-sm btn-success"
                                            href="{{ route('class-routine.edit', $routine->id) }}">Create New Routine</a>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
