@extends('layouts.master')

@section('content')
<div class="card">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Class Routine for {{ $classRoutine->studentClass->class_name }} - {{ $classRoutine->shift?->shift_name ?? "NA" }}</h6>
        <div class="m-0 float-right">
            <a href="{{ route('class-routine.index') }}" class="btn btn-info">Back</a>
            <button class="btn btn-sm btn-secondary" onclick="printCardBody()">Print</button>
        </div>
    </div>
    <div class="card-body" id="printableArea">
        @php
            $routinesByDay = $classRoutine->routineDetails->groupBy('day');
        @endphp
        
        @foreach(['Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday'] as $day)
            <h4>{{ $day }}</h4>
            <div class="table-responsive py-3">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Subject</th>
                            <th>Teacher</th>
                            <th>Start Time</th>
                            <th>End Time</th>
                            <th>Room No</th>
                        </tr>
                    </thead>
                    <tbody class="day-schedule">
                        @if(!isset($routinesByDay[$day]) || $routinesByDay[$day]->isEmpty())
                            <tr>
                                <td colspan="5" class="text-center">No classes scheduled for this day.</td>
                            </tr>
                        @else
                            @foreach($routinesByDay[$day] as $routineDetail)
                                <tr class="subject-entry" style="{{ ($routineDetail->teacher_id == auth()->user()->id && auth()->user()->user_type == 'teacher') ? 'background-color: #80dcff;' : '' }}">
                                    <td>{{ $routineDetail->subject->subject_name ?? 'N/A' }}</td>
                                    <td>{{ $routineDetail->teacher->name ?? 'N/A' }} </td>
                                    <td>{{ $routineDetail->start_time }}</td>
                                    <td>{{ $routineDetail->end_time }}</td>
                                    <td>{{ $routineDetail->class_room_id ?? 'N/A' }}</td>
                                </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        @endforeach
    </div>
</div>
@endsection

@push('scripts')
    <script>
        function printCardBody() {
            var printContents = document.getElementById('printableArea').innerHTML;
            var originalContents = document.body.innerHTML;
        
            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
            location.reload();
        }
    </script>
@endpush