@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
            <h6 class="m-0 table__top__txt">Assign Class Teachers</h6>
            <div class="m-0 float-right">
                <a href="{{ route('class_teachers.index') }}" class="btn btn-sm btn-light-blue">Class Teachers</a>
            </div>
        </div>
        <div class="card-body pt-3">
            <form action="{{ route('class_teachers.update', $id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row justify-content-center">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Shift</label>
                            <input type="text" class="form-control shift_id"
                                value="{{ $selectedClassTeacher?->shift?->shift_name ?? 'N/A' }}" readonly>
                            <input type="hidden" name="shift_id" value="{{ $selectedClassTeacher->shift_id }}">
                        </div>
                        <div class="form-group">
                            <label for="class_name">Class Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control student_class_id"
                                value="{{ $selectedClassTeacher?->studentClass?->class_name ?? 'N/A' }}" readonly>
                            <input type="hidden" name="student_class_id"
                                value="{{ $selectedClassTeacher->student_class_id }}">
                        </div>
                        <div class="form-group">
                            <label>Sections</label>
                            <input type="text" class="form-control section_id"
                                value="{{ $selectedClassTeacher?->section?->section_name ?? 'N/A' }}" readonly>
                            <input type="hidden" name="section_id" value="{{ $selectedClassTeacher->section_id }}">
                        </div>
                        <div class="form-group">
                            <label for="teacher_id">Class Teacher</label>
                            {{ generateDropdown($teachers, 'class="form-control select2" name="teacher_id" required', $selectedClassTeacher->class_teacher_id ?? '', '--Select Teacher--') }}
                        </div>
                        <div class="mt-3 flex justify-content-end">
                            <a href="{{ route('class_teachers.index') }}" type="button"
                                class="btn btn-default mr-3">Discard</a>
                            <button class="btn btn-submit" type="submit"
                                onclick="return confirm('Are you sure you want to save class Teachers')">Submit</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@stop

@section('scripts')
    <script>
        $('.student_class').on('change', function() {
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id =
            "{{ isset($selectedClassTeacher->student_class_id) ? $selectedClassTeacher->student_class_id : '' }}";

        if (student_class_id != '') {

            getSection(student_class_id);
        }

        function getSection(student_class_id) {
            let section_id = "{{ isset($selectedClassTeacher->section_id) ? $selectedClassTeacher->section_id : '' }}";
            if (student_class_id) {
                $.get('{{ route('sections.list_by_class') }}', {
                    student_class_id: student_class_id
                }, function(response) {
                    let sections = response;

                    let option = '<option value="">--Select Section--</option>';
                    for (let i = 0; i < sections.length; i++) {
                        // if(sections[i].student_class_id == student_class_id){
                        if (section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name +
                                '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + ' >' + sections[i].section_name +
                                '</option>';
                        }

                        // }
                    }
                    $('select.section_id').empty().append(option);
                });
            }
        }
    </script>
@endsection
