@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-lg-8 m-auto">
        <div class="card mt-4" id="print-layout">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Class Teacher List</h6>
                <div class="m-0 float-right">
                    @can('academic.assign-class-teacher.edit')
                    <a href="{{ route('class_teachers.create') }}" class="btn btn-sm btn-light-blue">Create</a>
                    @endcan
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table table-strip">
                            <thead class="thead-light">
                                <tr>
                                    <th>Class</th>
                                    <th>Shift</th>
                                    <th>Section</th>
                                    <th>Class Teacher</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($classTeachers as $classTeacher)
                                    <tr>
                                        <td>{{ $classTeacher->studentClass?->class_name ?? 'N/A' }}</td>
                                        <td>{{ $classTeacher->shift?->shift_name ?? "N/A" }}</td>
                                        <td>{{ $classTeacher?->section?->section_name }}</td>
                                        <td>
                                            <select name="teacher_id" class="form-control class-teacher-select" data-class-id="{{ $classTeacher->studentClass?->id ?? null }}" data-section-id="{{ $classTeacher?->section?->id }}" data-id="{{ $classTeacher->id }}">
                                                <option value="">-Select Teacher-</option>
                                                @foreach ($teachers as $teacherKey => $teacherVal)
                                                    <option @if($teacherKey == $classTeacher->classTeacher?->id) selected @endif value="{{ $teacherKey ?? 0 }}">{{ $teacherVal ?? '' }}</option>
                                                @endforeach
                                            </select>
                                        </td>

                                        <td class=" justify-content-start">
                                            @can('academic.assign-class-teacher.edit')
                                                <a href="{{ route('class_teachers.edit', $classTeacher->id) }}"
                                                    class="btn btn-soft-info btn-sm mr-1"><i class="fas fa-edit"></i></a>
                                            @endcan
                                            @can('academic.assign-class-teacher.delete')
                                                <form action="{{ route('class_teachers.destroy', $classTeacher->id) }}" method="POST"
                                                    class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-soft-danger btn-sm"
                                                        onclick="return confirm('Are you sure you want to delete this class time period?')"><i class="fas fa-trash"></i></button>
                                                </form>
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop
@section('scripts')
<script>
    $(document).ready(function () {
        // Save previous value before changing (mousedown is more reliable than focus)
        $('.class-teacher-select').on('mousedown', function () {
            $(this).data('prev', $(this).val());
        });
        // Handle change and revert if needed
        $('.class-teacher-select').on('change', function () {
            const $this = $(this);
            const id = $this.data('id');
            const classId = $this.data('class-id');
            const sectionId = $this.data('section-id');
            const selectedTeacherId = $this.val();
            const previousTeacherId = $this.data('prev') ?? ''; // fallback to empty if needed
            $.ajax({
                url: "{{ route('class_teachers.update.ajax') }}",
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    id: id,
                    class_id: classId,
                    section_id: sectionId,
                    teacher_id: selectedTeacherId
                },
                success: function (response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: response.success,
                            timer: 1500,
                            confirmButtonText: 'OK'
                        });
                        // Update previous to new value
                        $this.data('prev', selectedTeacherId);
                    } else if (response.warning) {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Warning',
                            text: response.warning,
                            timer: 1500,
                            confirmButtonText: 'OK'
                        });
                        // Revert selection WITHOUT triggering change
                        $this.val(previousTeacherId);
                    }
                },
                error: function () {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Something went wrong!',
                        timer: 1500,
                        confirmButtonText: 'OK'
                    });
                    // Optional: revert selection on error
                    $this.val(previousTeacherId);
                }
            });
        });
    });
</script>
@endsection
