@extends('layouts.master')
@section('content')

    <div class="card p-3 mb-3">
        <form action="{{ route('class_time_periods.search') }}" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <select name="student_class_id" id="student_class_id" class="form-control select2" required>
                            @foreach ($classes as $item)
                                @if($item->id==$student_class_id)
                                    <option value="{{ $item->id }}" selected> {{ $item->class_name }} </option>
                                @else
                                    <option value="{{ $item->id }}"> {{ $item->class_name }} </option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <!-- Add more fields here -->
                </div>
                <div class="col-md-6">
                    <button type="submit" class="btn btn-primary">Search</button>
                </div>
            </div>
        </form>
    </div>
    @if (isset($subjectsAssigns))
        <div class="card">
            <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
                Create Rutine<a class="btn btn-sm btn-success" href="{{ route('class_time_periods.index') }}">Rutine list</a>
            </div>

            <div class="card-body">
                <form action="{{ route('class_time_periods.store') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead class="thead-light">
                                        <th>SN</th>
                                        <th>Subject</th>
                                        <th>Teacher</th>
                                        <th>Start Time</th>
                                        <th>End Time</th>
                                        <th>Room No</th>
                                    </thead>
                                    <tbody>
                                        @php
                                            $sn = 0;
                                        @endphp
                                        @foreach ($subjectsAssigns as $key=>$subject)
                                            <tr>
                                                <td>{{++$sn}}</td>
                                                <td>{{$subject->subject->subject_name}}</td>
                                                <input type="hidden" name="subject_id[]" value="{{$subject->subject->id}}">
                                                <input type="hidden" name="student_class_id" value="{{$student_class_id}}">
                                                
                                                <td>
                                                    @php
                                                        $teacher_id = '';
                                                        if(isset($subject->teacher_id)){
                                                            $teacher_id = $subject->teacher_id;
                                                        }
                                                    @endphp
                                                    {{ generateDropdown($teachers, 'class="form-control-sm select2" name="teacher_id[]"', $teacher_id)  }}
                                                </td>

                                                <td>
                                                    <input type="time" name="start_time[]" value="{{$subject->start_time ?? ''}}" class="form-control">
                                                </td>

                                                <td>
                                                    <input type="time" name="end_time[]" value="{{$subject->end_time ?? ''}}" class="form-control">
                                                </td>

                                                <td>
                                                    <input type="text" name="room_no[]" value="{{$subject->class_room_id ?? ''}}" class="form-control" placeholder="Enter room no">
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <hr>
                    @if ($subjectsAssigns->isNotEmpty())
                        <div class="row">
                            <div class="col-md-6 offset-md-6">
                                <button type="submit" class="btn btn-primary mt-2 float-md-right">Save</button>
                            </div>
                        </div>
                    @endif
                </form>
            </div>
        </div>
    @endif

@stop

@section('scripts')
    <script>
        $('.building_id').on('change', function(){
            // alert($(this).val())
            let _this = $(this);
            let building_id =  _this.val();
            if(building_id){
                $.get('{{ route('building_floors.search_floor') }}', { building_id: building_id }, function(response) {
                    let building_floors = response;
                    let option = '';
                    for(let i=0;i<building_floors.length;i++){
                        if(building_floors[i].building_id == building_id){
                           option += '<option value='+building_floors[i].id+' >'+building_floors[i].floor_number+'</option>';
                        }
                    }
                    _this.closest('tr').find('td select.building_floor_id').append(option);
                });
            }
        });

        $('.building_floor_id').on('change', function(){
            let _this = $(this);
            let building_floor_id =  _this.val();
            if(building_floor_id){
                $.get('{{ route('class_rooms.search_rooms') }}', { building_floor_id: building_floor_id }, function(response) {
                    let class_rooms = response;
                    console.log(response);
                    let option = '';
                    for(let i=0;i<class_rooms.length;i++){
                        if(class_rooms[i].building_floor_id == building_floor_id){
                           option += '<option value='+class_rooms[i].id+' >'+class_rooms[i].room_no+'</option>';
                        }
                    }
                    _this.closest('tr').find('td select.class_room_id').append(option);
                });
            }
        });
    </script>
@endsection
