@extends('layouts.master')
@section('content')
    <style>
        .list-group {
            margin-bottom: 35px;
        }
    </style>

<div class="tab__item">
    <div class="row">
        <div class="col-xl-12 col-xxl-10 m-auto">
            <div class="card mt-4">
                <div class="card-body">
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#subject-tab" role="tab" >Subject</a>
                        </li>
                        {{-- <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#subject-assigns-tab" role="tab" >Subject Assigns</a>
                        </li> --}}
                    </ul>
                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div id="subject-tab" class="tab-pane fade {{ request()->query('tab', 'subject') === 'subject' ? 'show active' : '' }}">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Subjects</h6>
                                <div class="m-0 float-right">
                                    @can('academic.subjects-list.create')
                                        <button class="btn btn-sm btn-light-blue" id="add-student-btn" data-toggle="modal" data-target="#SubjectStoreModal">Add
                                            New</button>
                                    @endcan
                                </div>
                            </div>
                            <div class="table-responsive" >
                                <table class="table table-strip">
                                    <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Short Name</th>
                                        <th>Code</th>
                                        <th>Optional</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($subjects as $subject)
                                        <tr>
                                            <td>{{ $subject->id }}</td>
                                            <td>{{ $subject->subject_name }}</td>
                                            <td>{{ $subject->short_name }}</td>
                                            <td>{{ $subject->subject_code }}</td>
                                            <td>{{ $subject->is_optional ? 'Yes' : 'No' }}</td>
                                            <td class="d-flex justify-content-start">
                                                @can('academic.subjects-list.edit')
                                                    <button class="btn btn-sm btn-soft-info mx-1" id="add-student-btn" data-toggle="modal"
                                                            data-target="#SubjectEditModal" data-name="{{ $subject->subject_name }}"
                                                            data-short-name="{{ $subject->short_name }}"
                                                            data-code="{{ $subject->subject_code }}" data-status="{{ $subject->is_optional }}"
                                                            data-id="{{ $subject->id }}"><i class="fas fa-edit"></i></button>
                                                @endcan
                                                @can('academic.subjects-list.delete')
                                                    <form action="{{ route('subjects.destroy', $subject->id) }}" method="POST"
                                                          class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-soft-danger btn-sm"
                                                                onclick="return confirm('Are you sure you want to delete this subject?')"><i class="fas fa-trash"></i></button>
                                                    </form>
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div id="subject-assigns-tab" class="tab-pane fade {{ request()->query('tab') === 'subject-assigns' ? 'show active' : '' }}">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">Subject Assigned List</h6>
                                <div class="m-0 float-right">
                                    @can('academic.subjects-assigns.create')
                                        <a class="btn btn-sm btn-light-blue" href="{{ route('subjects_assigns.create') }}">Add New</a>
                                    @endcan
                                </div>
                            </div>
                            @foreach ($subjectsAssigns as $classId => $subjects)
                                {{-- <div class="row">
                                    <div class="col-md-12"> --}}
                                <div class="d-flex align-items-center justify-content-between mt-3">
                                    <div class="align-items-start">
                                        <label>Class: {{ $subjects->first()->studentClass->class_name }}</label>
                                    </div>
                                    <div class="d-flex justify-content-start mb-2">
                                        @can('academic.subjects-assigns.edit')
                                            <a href="{{ route('subjects_assigns.edit', $subjects->first()->student_class_id) }}"
                                               class="btn btn-soft-info btn-sm mr-1"><i class="fas fa-edit"></i></a>
                                        @endcan
                                        @can('academic.subjects-assigns.delete')
                                            <form action="{{ route('subjects_assigns.destroy', $subjects->first()->student_class_id) }}"
                                                  method="POST">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-soft-danger btn-sm"
                                                        onclick="return confirm('Are you sure you want to delete this class?')"><i class="fas fa-trash"></i></button>
                                            </form>
                                        @endcan
                                    </div>
                                </div>
                                <ul class="list-group">
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <span>
                                                @foreach ($subjects as $index => $subject)
                                                    <span class="badge badge-light p-2 rounded-sm m-1 ">{{ $subject->subject->subject_name }}</span>
                                                    {{-- @if ($index !== $subjects->count() - 1)
                                                        ,
                                                    @endif --}}
                                                @endforeach
                                            </span>
                                    </li>
                                </ul>
                                {{-- </div>
                            </div> --}}
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- subject create Modal -->
    <div class="modal fade" id="SubjectStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('subjects.store') }}">
                    @csrf
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Subject </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>

                        <div class="form-group">
                            <label for="subject_name" class="form-label">Subject Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="subject_name" name="subject_name"
                                placeholder="Enter subject name" required>
                        </div>

                        <div class="form-group">
                            <label for="short_name" class="form-label">Short Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="short_name" name="short_name"
                                placeholder="Enter short name" required>
                        </div>

                        <div class="form-group">
                            <label for="subject_code" class="form-label">Subject Code</label>
                            <input type="text" class="form-control" id="subject_code" name="subject_code"
                                placeholder="Enter subject code">
                        </div>

                        <div class="form-group">
                            <label for="is_optional" class="form-label">Is Optional</label>
                            <select class="form-control" id="is_optional" name="is_optional" required>
                                <option value="0">No</option>
                                <option value="1">Yes</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="SubjectEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('subjects.update') }}">
                    @csrf
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Subject </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="subject_name" class="form-label">Subject Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="subject_name" name="subject_name"
                                placeholder="Enter subject name" required>
                        </div>

                        <div class="form-group">
                            <label for="short_name" class="form-label">Short Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="short_name" name="short_name"
                                placeholder="Enter short name" required>
                        </div>

                        <div class="form-group">
                            <label for="subject_code" class="form-label">Subject Code</label>
                            <input type="text" class="form-control" id="subject_code" name="subject_code"
                                placeholder="Enter subject code">
                        </div>

                        <div class="form-group">
                            <label for="is_optional" class="form-label">Is Optional</label>
                            <select class="form-control" id="is_optional" name="is_optional" required>
                                <option value="0">No</option>
                                <option value="1">Yes</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->
@stop

@section('scripts')
    <script type="text/javascript">


        // Save active tab on click
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            localStorage.setItem('activeTab', $(e.target).attr('href'));
        });

        // Load active tab on page reload
        $(document).ready(function () {
            var activeTab = localStorage.getItem('activeTab');
            if (activeTab) {
                $('a[href="' + activeTab + '"]').tab('show');
            }
        });


        $('#SubjectEditModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget)
            var subject_name = button.data('name')
            var shortName = button.data('short-name')
            var code = button.data('code')
            var status = button.data('status')
            var id = button.data('id')
            console.log(subject_name);
            var modal = $(this)
            modal.find('#subject_name').val(subject_name)
            modal.find('#short_name').val(shortName)
            modal.find('#subject_code').val(code)
            modal.find("#is_optional option[value=" + status + "]").prop("selected", true);
            modal.find('#id').val(id)
        })
    </script>
@endsection
