@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
            Assign Class Teachers<a class="btn btn-sm btn-success" href="{{ route('class_teachers.index') }}">Class Teachers</a>
        </div>
        <div class="card-body">
            <form action="{{ route('class_teachers.update', $id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row justify-content-center">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="class_name">Class Name *</label>
                            {{ generateDropdown($studentClasses, 'class="form-control student_class" id="student_class" name="student_class_id" required', $selectedClassTeacher->class_id ?? '', "Select Class") }}
                        </div>
                        <div class="form-group">
                            <label>Sections</label>
                            {{ generateDropdown($sections, 'class="form-control section_id" id="section_id" name="section_id"', $selectedClassTeacher->section_id ?? '', 'Select Section') }}
                        </div>
                        <div class="form-group">
                            <label for="teacher_id">Class Teacher</label>
                            {{ generateDropdown($teachers, 'class="form-control select2" name="teacher_id"', $selectedClassTeacher->class_teacher_id ?? '') }}
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary" onclick="return confirm('Are you sure you want to save class Teachers')">Save</button>
                            <a href="{{ route('class_teachers.index') }}" class="btn btn-secondary ml-2">Cancel</a>
                        </div>
                    </div>
                </div>
               
            </form>
        </div>
    </div>
@stop

@section('scripts')
    <script>
        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ isset($selectedClassTeacher->class_id) ? $selectedClassTeacher->class_id : '' }}";

        if(student_class_id!=''){
            
            getSection(student_class_id);
        }

        function getSection(student_class_id){
            let section_id = "{{ isset($selectedClassTeacher->section_id) ? $selectedClassTeacher->section_id : '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;
                    
                    let option = '<option value="">--Select Section--</option>';
                    for(let i=0;i<sections.length;i++){
                        // if(sections[i].student_class_id == student_class_id){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }
                           
                        // }
                    }
                    $('select.section_id').empty().append(option);
                });
            }
        }
    </script>
@endsection
