@extends('layouts.master')
@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Class Teacher List</h6>
        <div class="m-0 float-right">
            @can('academic.assign-class-teacher.create')
            <a class="btn btn-sm btn-success" href="{{ route('subject-teachers.create') }}">Assign Class Teacher</a>
            @endcan
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table table-strip">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Class</th>
                            <th>Section</th>
                            <th>Class Teacher</th>
                            <th class="action__col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($classTeachers as $classTeacher)
                            <tr>
                                <td>{{ $classTeacher->id }}</td>
                                <td>{{ $classTeacher->studentClass->class_name }}</td>
                                <td>{{ $classTeacher->section->section_name }}</td>
                                <td>{{ $classTeacher->classTeacher?->first_name.' '.$classTeacher->classTeacher?->first_name }}</td>
                                <td class="d-flex justify-content-start">
                                    @can('academic.assign-class-teacher.edit')
                                        <a href="{{ route('subject-teachers.edit', $classTeacher->id) }}"
                                            class="btn btn-soft-info btn-sm mr-1"><i class="fas fa-edit"></i></a>
                                    @endcan
                                    @can('academic.assign-class-teacher.delete')
                                        <form action="{{ route('class_time_periods.destroy', $classTeacher->id) }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-soft-danger btn-sm"
                                                onclick="return confirm('Are you sure you want to delete this class time period?')"><i class="fas fa-trash"></i></button>
                                        </form>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@stop
