@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-lg-8 m-auto">
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Subject List</h6>
                <div class="m-0 float-right">
                    @can('academic.subjects-list.create')
                        <button class="btn btn-sm btn-light-blue" id="add-student-btn" data-toggle="modal" data-target="#dataStoreModal">Add
                            New</button>
                    @endcan
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table table-strip">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Short Name</th>
                                    <th>Code</th>
                                    <th>Optional</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($subjects as $subject)
                                    <tr>
                                        <td>{{ $subject->id }}</td>
                                        <td>{{ $subject->subject_name }}</td>
                                        <td>{{ $subject->short_name }}</td>
                                        <td>{{ $subject->subject_code }}</td>
                                        <td>{{ $subject->is_optional ? 'Yes' : 'No' }}</td>
                                        <td class="d-flex justify-content-start">
{{--                                            @can('academic.subjects-list.view')--}}
{{--                                                <a href="{{ route('subjects.show', $subject->id) }}"--}}
{{--                                                    class="btn btn-soft-success btn-sm"><i class="fas fa-eye"></i></a>--}}
{{--                                            @endcan--}}
                                            @can('academic.subjects-list.edit')
                                                <button class="btn btn-sm btn-soft-info mx-1" id="add-student-btn" data-toggle="modal"
                                                    data-target="#dataEditModal" data-name="{{ $subject->subject_name }}"
                                                    data-short-name="{{ $subject->short_name }}"
                                                    data-code="{{ $subject->subject_code }}" data-status="{{ $subject->is_optional }}"
                                                    data-id="{{ $subject->id }}"><i class="fas fa-edit"></i></button>
                                            @endcan
                                            @can('academic.subjects-list.delete')
                                                <form action="{{ route('subjects.destroy', $subject->id) }}" method="POST"
                                                    class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-soft-danger btn-sm"
                                                        onclick="return confirm('Are you sure you want to delete this subject?')"><i class="fas fa-trash"></i></button>
                                                </form>
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
    <!-- create Modal -->
    <div class="modal fade" id="dataStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('subjects.store') }}">
                    @csrf
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Subject </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>

                        <div class="form-group">
                            <label for="subject_name" class="form-label">Subject Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="subject_name" name="subject_name"
                                placeholder="Enter subject name" required>
                        </div>

                        <div class="form-group">
                            <label for="short_name" class="form-label">Short Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="short_name" name="short_name"
                                placeholder="Enter short name" required>
                        </div>

                        <div class="form-group">
                            <label for="subject_code" class="form-label">Subject Code</label>
                            <input type="text" class="form-control" id="subject_code" name="subject_code"
                                placeholder="Enter subject code">
                        </div>

                        <div class="form-group">
                            <label for="is_optional" class="form-label">Is Optional</label>
                            <select class="form-control" id="is_optional" name="is_optional" required>
                                <option value="0">No</option>
                                <option value="1">Yes</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->

    <!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('subjects.update') }}">
                    @csrf
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Subject </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="subject_name" class="form-label">Subject Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="subject_name" name="subject_name"
                                placeholder="Enter subject name" required>
                        </div>

                        <div class="form-group">
                            <label for="short_name" class="form-label">Short Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="short_name" name="short_name"
                                placeholder="Enter short name" required>
                        </div>

                        <div class="form-group">
                            <label for="subject_code" class="form-label">Subject Code</label>
                            <input type="text" class="form-control" id="subject_code" name="subject_code"
                                placeholder="Enter subject code">
                        </div>

                        <div class="form-group">
                            <label for="is_optional" class="form-label">Is Optional</label>
                            <select class="form-control" id="is_optional" name="is_optional" required>
                                <option value="0">No</option>
                                <option value="1">Yes</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->
@stop
@section('scripts')
    <script type="text/javascript">
        $('#dataEditModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget)
            var subject_name = button.data('name')
            var shortName = button.data('short-name')
            var code = button.data('code')
            var status = button.data('status')
            var id = button.data('id')
            console.log(subject_name);
            var modal = $(this)
            modal.find('#subject_name').val(subject_name)
            modal.find('#short_name').val(shortName)
            modal.find('#subject_code').val(code)
            modal.find("#is_optional option[value=" + status + "]").prop("selected", true);
            modal.find('#id').val(id)
        })
    </script>
@endsection
