@extends('layouts.master')
@section('content')

<div class="card">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Assign Subject</h6>
        <div class="m-0 float-right">
            <a href="{{ route('subjects_assigns.index') }}" class="btn btn-sm btn-light-blue">View All</a>
        </div>
    </div>
    <div class="card-body">
        <div class="d-flex justify-content-center">
            <form action="{{ route('subjects_assigns.store') }}" method="POST" class="col-md-6">
                @csrf
                <div class="form-group">
                    <label for="class_id">Select Class <span class="text-danger">*</span></label>
                    <select name="class_id" id="class_id" class="form-control" required>
                        @foreach ($classes as $class)
                            <option value="{{ $class->id }}">{{ $class->class_name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group">
                    <label for="group_id">Group</label>
                    <select name="group_id" id="group_id" class="form-control">
                        <option value="">--Select Group--</option>
                        @foreach ($groups as $group)
                            <option value="{{ $group->id }}">{{ $group->group_name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group mt-3">
                    <label>Select Subjects:</label>
                    <hr>
                    <div class="row">
                        @foreach ($subjects as $subject)
                            <div class="col-sm-12 col-md-12 col-lg-6">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="subject_{{ $subject->id }}" name="subjects[]" value="{{ $subject->id }}">
                                    <label class="form-check-label" for="subject_{{ $subject->id }}">{{ $subject->subject_name }}</label>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <br>
                <button type="submit" class="btn btn-submit submitBtn">Submit</button>
            </form>
        </div>
    </div>
</div>

@stop
