@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Assign Subject</h6>
        <div class="m-0 float-right">
            <a href="{{ route('subjects_assigns.index') }}" class="btn btn-sm btn-light-blue">View All</a>
        </div>
    </div>

    <div class="card-body">
        <div class="d-flex justify-content-center">
            <form action="{{ route('subjects_assigns.update', $classId) }}" method="POST" class="col-md-6">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <label for="class_id">Select Class <span class="text-danger">*</span></label>
                    <select name="class_id" id="class_id" class="form-control" @disabled(true)>
                        @foreach ($classes as $class)
                            <option value="{{ $class->id }}" {{$classId == $class->id ? 'selected' : '' }}>
                                {{ $class->class_name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="group_id">Group</label>
                    <select name="group_id" id="group_id" class="form-control">
                        <option value="">--Select Group--</option>
                        @foreach ($groups as $group)
                            <option value="{{ $group->id }}" 
                                {{ isset($groupId) && $groupId == $group->id ? 'selected' : '' }}>
                                {{ $group->group_name }}
                            </option>
                        @endforeach
                    </select>
                </div>


                <div class="form-group mt-3">
                    <label>Select Subjects</label>
                    <hr>
                    <div class="row">
                        @foreach ($subjects as $subject)
                            <div class="col-sm-12 col-md-12 col-lg-6">
                                <div class="form-check">
                                    <input type="checkbox" name="subjects[]" value="{{ $subject->id }}"
                                        {{ in_array($subject->id, $assignedSubjects) ? 'checked' : '' }}>
                                    <label>{{ $subject->subject_name }}</label><br>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <br>
                <a href="{{ route('subjects_assigns.index') }}" type="submit" class="btn btn-default mr-3">Discard</a>
                <button type="submit" class="btn btn-submit">Submit</button>
            </form>
        </div>
    </div>
</div>

@stop
