@extends('layouts.master')
<style>
    .subject-box {
        display: inline-block;
        padding: 5px 10px;
        background-color: #f0f0f0;
        border-radius: 5px;
        margin-right: 5px;
    }
</style>

@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Assigned Subject List</h6>
        <div class="m-0 float-right">
            @can('academic.subjects-assigns.create')
                <a class="btn btn-sm btn-light-blue" href="{{ route('subjects_assigns.create') }}">Add New</a>
            @endcan
        </div>
    </div>
    <div class="card-body">
        @foreach ($subjectsAssigns as $classId => $subjects)
            <div class="row">
                <div class="col-md-12">
                    <div class="d-flex align-items-center justify-content-between mt-3">
                        <div class="align-items-start">
                            <h4>Class: {{ $subjects->first()->studentClass->class_name }}  {{ optional($subjects->first()->group)->group_name ? '- ' . $subjects->first()->group->group_name : '' }}</h4>
                        </div>
                        <div class="d-flex justify-content-start">
                            @can('academic.subjects-assigns.edit')
                                <a href="{{ route('subjects_assigns.edit', ['student_class_id' => $subjects->first()->student_class_id]) }}"
                                    class="btn btn-soft-info btn-sm mr-1"><i class="fas fa-edit"></i></a>
                            @endcan
                            @can('academic.subjects-assigns.delete')
                                <form action="{{ route('subjects_assigns.destroy', ['student_class_id' => $subjects->first()->student_class_id])}}"
                                    method="POST">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-soft-danger btn-sm"
                                        onclick="return confirm('Are you sure you want to delete this class?')"><i class="fas fa-trash"></i></button>
                                </form>
                            @endcan
                        </div>
                    </div>
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>
                                @foreach ($subjects as $index => $subject)
                                    <div class="subject-box m-1">{{ $subject->subject->subject_name }}</div>
                                    @if ($index !== $subjects->count() - 1)
                                        
                                    @endif
                                @endforeach
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
        @endforeach
    </div>
</div>
@stop
