@extends('layouts.master')
@section('content')
<style>
    .subject-box {
        display: inline-block;
        padding: 5px 10px;
        background-color: #f0f0f0;
        border-radius: 5px;
        margin-right: 5px;
    }
</style>
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Teacher Enrollment</h6>
        <div class="m-0 float-right">
            <a href="{{ route('teachers-enroll.index') }}" class="btn btn-sm btn-light-blue">View All</a>
        </div>
    </div>
    <div class="card-body">
        <form method="post" action="{{ route('teachers-enroll.store') }}">
            @csrf
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="teacher_id">Teacher</label>
                        <select name="teacher_id" id="teacher_id" class="form-control select2" required>
                            <option value="">Select Teacher</option>
                            @foreach ($teachers as $teacher)
                                <option value="{{ $teacher->user_id }}">{{ $teacher->name ?? 'N/A' }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            @foreach ($sections as $section)
                <div class="row g-0 align-items-stretch">
                    @foreach ($subjectsAssigns as $classId => $subjects)
                        <div class="col-md-2 mb-4">
                            <div class="item border p-3 h-100">
                                <div class="d-flex align-items-center justify-content-between mt-3">
                                    <div class="align-items-start mb-2">
                                        <h5>{{ $subjects->first()->studentClass->class_name }} - {{$section->section_name}}</h5>
                                    </div>
                                </div>
                                @foreach ($subjects as $index => $subject)
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="section_{{$section->id}}_subject_{{ $subject->id }}" name="class_subject_ids[]" value="{{ $section->id . ',' . $subjects->first()->studentClass->id . ',' . $subject->subject->id }}">
                                        <label class="form-check-label" for="section_{{$section->id}}_subject_{{ $subject->id }}">{{ $subject->subject->subject_name }}</label>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
            @endforeach
            <div class="row">
                <div class="col-md-12 ">
                    <br>
                    <a href="{{ route('teachers-enroll.index') }}" type="submit" class="btn btn-default mt-3 mr-3">Discard</a>
                    <button type="submit" class="btn btn-submit mt-3">Submit</button>
                </div>
            </div>
        </form>
    </div>
</div>
@stop
