@extends('layouts.master')
@section('content')
<style>
    .subject-box {
        display: inline-block;
        padding: 5px 10px;
        background-color: #f0f0f0;
        border-radius: 5px;
        margin-right: 5px;
    }
</style>
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Teacher Enrollment</h6>
        <div class="m-0 float-right">
            
        </div>
    </div>
    <div class="card-body">
        <form method="post" action="{{ route('teachers-enroll.update') }}">
            @csrf
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="teacher_id">Teacher</label>
                        <select name="teacher_id" id="teacher_id" class="form-control select2" required>
                            <option value="">Select Teacher</option>
                            @foreach ($teachers as $teacher)
                                <option @if ($enrollTeacherInfo->teacher_id == $teacher->user_id) selected @endif
                                     value="{{ $teacher->user_id }}">{{ $teacher->name ?? 'N/A' }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            
            @foreach ($sections as $section)
                <div class="row">
                    @foreach ($subjectsAssigns as $classId => $subjects)
                        <div class="col-md-2">
                            <div class="d-flex align-items-center justify-content-between mt-3">
                                <div class="align-items-start">
                                    <h4>Class: {{ $subjects->first()->studentClass->class_name }} {{$section->section_name}}</h4>
                                </div>
                            </div>
                            @foreach ($subjects as $index => $subject)
                                <div class="form-check">

                                    <input type="checkbox" class="form-check-input"
    id="section_{{$section->id}}_subject_{{ $subject->id }}"
    name="class_subject_ids[]"
    value="{{ $section->id . ',' . $subjects->first()->studentClass->id . ',' . $subject->subject->id }}"
    @if(in_array($section->id . ',' . $subjects->first()->studentClass->id . ',' . $subject->subject->id, $selectedEnrollments)) checked @endif
>

                                    <label class="form-check-label" for="section_{{$section->id}}_subject_{{ $subject->id }}">{{ $subject->subject->subject_name }}</label>
                                </div>
                            @endforeach
                        </div>
                    @endforeach
                </div>
            @endforeach
            <div class="row">
                <div class="col-md-12 ">
                    <button type="submit" class="btn btn-primary mt-3 float-right">Uodate</button>
                </div>
            </div>
        </form>
    </div>
</div>
@stop
