@extends('layouts.master')
@section('content')

<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Teacher Enrollment List</h6>
                <div class="m-0 float-right">
                    @can('academic.teacher-enroll.create')
                        <a class="btn btn-sm btn-light-blue" href="{{ route('teachers-enroll.create') }}">Add New</a>
                    @endcan

                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table">
                            <thead class="thead-light">
                            <tr>
                                <th>Teacher</th>
                                <th>Subjects</th>
                                <th class="action__col">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @if($enrolls->isNotEmpty())
                                @foreach($enrolls as $enroll)
                                    <tr>
                                        <td>{{ $enroll->teacher_name }}</td>
                                        <td>{{ $enroll->subjects_detail }} </td>
                                        <td class="d-flex justify-content-start">
                                            @can('academic.teacher-enroll.edit')
                                            <a href="{{ route('teachers-enroll.edit', $enroll->id) }}"
                                            class="btn btn-soft-info btn-sm mr-1"><i class="fas fa-edit"></i></a>
                                            @endcan
                                            @can('academic.teacher-enroll.delete')
                                            <form action="{{ route('teachers-enroll.destroy', $enroll->id) }}"
                                                    method="POST"
                                                    class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-soft-danger btn-sm"
                                                        onclick="return confirm('Are you sure you want to delete this branch?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="6" class="text-center">No data available in table</td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop
