@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-xl-12 col-xxl-8 m-auto">
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6 class="m-0 table__top__txt">Accounting Head</h6>
                <div class="m-0 float-right">
                    @can('accounting.accounting-head.create')
                        <button class="btn btn-sm btn-light-blue" id="add-head-btn" data-toggle="modal" data-target="#dataStoreModal">Add New</button>
                    @endcan
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table" id="dataTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Head Name</th>
                                    <th>Head Type</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $sn = 0;
                                @endphp
                                @foreach($accounting_heads as $head)
                                <tr>
                                    <td>{{ ++$sn }}</td>
                                    <td>{{ $head->name }}</td>
                                    <td>{{ ucfirst($head->type) }}</td>
                                    <td class="d-flex justify-content-start">
                                        @can('accounting.accounting-head.edit')
                                            <button class="btn btn-sm btn-soft-info edit-head-btn mr-1" data-toggle="modal" data-target="#dataStoreModal" data-id="{{ $head->id }}" data-name="{{ $head->name }}" data-type="{{ $head->type }}"><i class="fas fa-edit"></i></button>
                                        @endcan
                                        @can('accounting.accounting-head.delete')
                                            <form action="{{ route('accounting_head.destroy', $head->id) }}" method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure?')"><i class="fas fa-trash"></i></button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="dataStoreModal" role="dialog">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id="headForm" method="POST">
                @csrf
                @method('POST')
                <input type="hidden" name="_method" id="formMethod">
                <div class="modal-header">
                    <h4 class="modal-title" id="modalTitle">Create Accounting Head</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                        <span class="sr-only">Close</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="name">Head Name <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" id="head_name" placeholder="Enter Accounting Head Name" required>
                    </div>
                    <div class="form-group">
                        <label for="type">Head Type <span class="text-danger">*</span></label>
                        <select name="type" class="form-control type" id="type" required>
                            <option value="">--Select Head Type--</option>
                            @foreach ($types as $type)
                                <option value="{{$type}}">{{ucfirst($type)}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
@section('scripts')
<script>
    $(document).ready(function () {
        $('#dataStoreModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget);
            var name = button.data('name') || '';
            var type = button.data('type') || '';
            var id = button.data('id') || '';
            var modal = $(this);
            var form = modal.find('form');
            var actionUrl = id ? '/accounting-head/update/' + id : '/accounting-head/store';
            var method = id ? 'PUT' : 'POST';
            form.attr('action', actionUrl);
            modal.find('#head_name').val(name);
            modal.find('#type option[value="' + type + '"]').prop('selected', true); // Add this line
            modal.find('#formMethod').val(method);
            modal.find('#modalTitle').text(id ? 'Edit accounting head' : 'Create accounting head');
            modal.find('[name="_method"]').val(method);
        });
        $('#add-head-btn').on('click', function () {
            resetModal();
        });
        function resetModal() {
            var modal = $('#dataStoreModal');
            var form = modal.find('form');
            form.attr('action', '/accounting-head');
            modal.find('#head_name').val('');
            modal.find('#type').val('');
            modal.find('#formMethod').val('POST');
            modal.find('[name="_method"]').val('POST');
            modal.find('#modalTitle').text('Create accounting head');
        }
    });
</script>
@endsection
@stop
