    @extends('layouts.master')
    @section('content')
    <div class="row">
        <div class="col-xl-12 col-xxl-10 m-auto">
            @if ($errors->any())
                <div class="alert alert-danger m-3">
                    <ul class="m-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="card mt-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                    <h6 class="m-0 table__top__txt">Bank Amount</h6>
                    <div class="m-0 float-right">
                        <button class="btn btn-sm btn-light-blue" data-toggle="modal" data-target="#dataStoreModal">Add New</button>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive" >
                            <table class="table" id="dataTable">
                                <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Account Type</th>
                                        <th>Account Name</th>
                                        <th>Account Number</th>
                                        <th>Branch Address</th>
                                        <th>Bank Name</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $sn = 0;
                                    @endphp
                                    @foreach ($accounts as $account)
                                        <tr>
                                            <td>{{ ++$sn }}</td>
                                            <td>{{$account->account_type}}</td>
                                            <td>{{$account->account_name}}</td>
                                            <td>{{$account->account_number}}</td>
                                            <td>{{$account->branch_address}}</td>
                                            <td>{{$account->bank_name}}</td>
                                            <td class="d-flex justify-content-start">
                                                @can('accounting.class-wise-fees.edit')
                                                    <button class="btn btn-sm btn-soft-info edit-expense-btn mr-1" data-toggle="modal"
                                                        data-target="#dataEditModal" data-id="{{ $account->id }}"
                                                        data-account_type="{{ $account->account_type }}" data-account_name="{{ $account->account_name }}"
                                                        data-opening_date="{{ view_date_format($account->opening_date) }}"
                                                        data-branch_address="{{ $account->branch_address }}"  data-bank_name="{{ $account->bank_name }}"
                                                        data-account_number="{{ $account->account_number }}"
                                                        data-contact_number="{{ $account->contact_number }}"
                                                    >
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                @endcan
                                                @can('accounting.class-wise-fees.delete')
                                                    <form action="{{ route('bank_account.destroy', [$account->id]) }}"
                                                        method="POST"
                                                        onsubmit="return confirm('Are you sure you want to delete this')"
                                                        style="display:inline-block;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                                    </form>
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

        <!-- create Modal -->
        <div class="modal fade" id="dataStoreModal" role="dialog">
            <div class="modal-dialog modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form role="form" id='myForm' method="POST" action="{{ route('bank_account.store') }}">
                        @csrf
                        <!-- Modal Header -->
                        <div class="modal-header">
                            <div class="float-start">
                                <h4 class="modal-title" id="myModalLabel">Add Bank Account</h4>
                            </div>
                            <div class="float-end d-none">
                                <button type="button" class="close" data-dismiss="modal">
                                    <span aria-hidden="true">&times;</span>
                                    <span class="sr-only">Close</span>
                                </button>
                            </div>
                        </div>
                        <!-- Modal Body -->
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="account_type">Account Type <span class="text-danger">*</span></label>
                                        <select class="form-control form-control-sm account_type" name="account_type" id="account_type" required>
                                            <option value="">-- Select Account Type --</option>
                                            @foreach ($types as $type)
                                            <option value="{{$type}}">{{$type}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="account_name">Account Name <span class="text-danger">*</span></label>
                                        <input id="account_name" type="text" required class="form-control form-control-sm" name="account_name" value="{{ old('account_name') }}" placeholder="Enter Account Name">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="account_number">Account Number <span class="text-danger">*</span></label>
                                        <input id="account_number" type="text" required class="form-control form-control-sm" name="account_number" value="{{ old('account_number') }}" placeholder="Enter Account Number">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bank_name">Bank Name <span class="text-danger">*</span></label>
                                        <input id="bank_name" type="text" required class="form-control form-control-sm" name="bank_name" value="{{ old('bank_name') }}" placeholder="Enter Bank Name">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="branch_address">Branch Address <span class="text-danger">*</span></label>
                                        <textarea name="branch_address" id="branch_address" placeholder="Branch Address" class="form-control form-control-sm" rows="4" required></textarea>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="contact_number">Contact Number</label>
                                        <input id="contact_number" type="number" min="0" class="form-control form-control-sm" name="contact_number" value="{{ old('contact_number') }}" placeholder="Enter Contact Number">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="opening_date">Opening Date </label>
                                        <input id="opening_date" type="text" class="form-control form-control-sm date3601" name="opening_date" value="{{ old('opening_date') }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Modal Footer -->
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                            <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- modal end -->
        <!--edit Modal -->
        <div class="modal fade" id="dataEditModal" role="dialog">
            <div class="modal-dialog modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form role="form" id='myForm2' method="POST" action="{{ route('bank_account.update') }}">
                        @csrf
                        <!-- Modal Header -->
                        <div class="modal-header">
                            <div class="float-start">
                                <h4 class="modal-title" id="myModalLabel2">Edit Bank Account </h4>
                            </div>
                            <div class="float-end d-none">
                                <button type="button" class="close" data-dismiss="modal">
                                    <span aria-hidden="true">&times;</span>
                                    <span class="sr-only">Close</span>
                                </button>
                            </div>
                        </div>
                        <!-- Modal Body -->
                        <div class="modal-body">
                            <input type="hidden" id="id" name="id">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="account_type_edit">Account Type <span class="text-danger">*</span></label>
                                        <select class="form-control form-control-sm account_type" name="account_type" id="account_type_edit" required>
                                            <option value="">-- Select Account Type --</option>
                                            @foreach ($types as $type)
                                            <option value="{{$type}}">{{$type}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="account_name_edit">Account Name <span class="text-danger">*</span></label>
                                        <input id="account_name_edit" type="text" required class="form-control form-control-sm" name="account_name" value="{{ old('account_name') }}" placeholder="Enter Account Name">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="account_number_edit">Account Number <span class="text-danger">*</span></label>
                                        <input id="account_number_edit" type="text" required class="form-control form-control-sm" name="account_number" value="{{ old('account_number') }}" placeholder="Enter Account Number">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bank_name_edit">Bank Name <span class="text-danger">*</span></label>
                                        <input id="bank_name_edit" type="text" required class="form-control form-control-sm" name="bank_name" value="{{ old('bank_name') }}" placeholder="Enter Bank Name">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="branch_address_edit">Branch Address <span class="text-danger">*</span></label>
                                        <textarea name="branch_address" id="branch_address_edit" placeholder="Branch Address" class="form-control form-control-sm" rows="4" required></textarea>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="contact_number_edit">Contact Number</label>
                                        <input id="contact_number_edit" type="number" min="0" class="form-control form-control-sm" name="contact_number" value="{{ old('contact_number') }}" placeholder="Enter Contact Number">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="opening_date_edit">Opening Date </label>
                                        <input id="opening_date_edit" type="text" class="form-control form-control-sm date3603" name="opening_date" value="{{ old('opening_date') }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Modal Footer -->
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                            <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- modal end -->
    @endsection
    @section('scripts')
        <script type="text/javascript">
            const today = new Date();
            $('.date3601').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                todayHighlight: true,
            }).datepicker('setDate', today);

            $('.date3603').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                todayHighlight: true,
            })

            $('#dataEditModal').on('hidden.bs.modal', function () {
                // Reset the form inside the modal
                $(this).find('form')[0].reset();
                // Optionally, reset specific fields manually (in case you're setting them dynamically)
                $(this).find('.form-control').val('');
                $(this).find('.form-control-sm').val('');
            });

            $('#dataEditModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget)
                var account_type = button.data('account_type')
                var account_name = button.data('account_name')
                var opening_date = button.data('opening_date')
                var description = button.data('description')
                var branch_address = button.data('branch_address')
                var bank_name = button.data('bank_name')
                var account_number = button.data('account_number')
                var contact_number = button.data('contact_number')
                var id = button.data('id')
                var modal = $(this)
                // Populate the modal fields with data only if they are empty
                if (!modal.find('#id').val()) {
                    modal.find('#id').val(id)
                }
                if (!modal.find('#account_name_edit').val()) {
                    modal.find('#account_name_edit').val(account_name)
                }
                if (!modal.find('#account_number_edit').val()) {
                    modal.find('#account_number_edit').val(account_number)
                }
                if (!modal.find("#account_type_edit").val()) {
                    var accountTypeValue = account_type.replace(/"/g, '\\"'); // Escape quotes if needed
                    modal.find("#account_type_edit option[value='" + accountTypeValue + "']").prop("selected", true);
                }
                if (!modal.find('#bank_name_edit').val()) {
                    modal.find('#bank_name_edit').val(bank_name)
                }
                if (!modal.find('#branch_address_edit').val()) {
                    modal.find('#branch_address_edit').val(branch_address)
                }
                if (!modal.find('#contact_number_edit').val()) {
                    modal.find('#contact_number_edit').val(contact_number)
                }
                if (!modal.find('#opening_date_edit').val()) {
                    modal.find('#opening_date_edit').val(opening_date)
                }
            });
        </script>
    @endsection
