@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-xl-12 col-xxl-10 m-auto">
    @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6 class="m-0 table__top__txt">Bank Amount Deposit</h6>
                <div class="m-0 float-right">
                    <button class="btn btn-sm btn-light-blue" data-toggle="modal" data-target="#dataStoreModal">Add New</button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table" id="dataTable">
                            <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Bank Account</th>
                            {{-- <th>Deposit Type</th> --}}
                            <th>Amount</th>
                            <th>Transaction ID</th>
                            <th>Check Number</th>
                            <th>Date</th>
                            <th>Note</th>
                            <th>Attachment</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $sn = 0;
                        @endphp
                        @foreach ($deposits as $deposit)
                            <tr>
                                <td>{{ ++$sn }}</td>
                                <td>{{ $bankAccounts[$deposit->bank_account_id] }}</td>
                                {{-- <td>{{ $accountingHeads[$deposit->accounting_head_id] }}</td> --}}
                                <td>{{$deposit->amount}}</td>
                                <td>{{$deposit->transaction_id}}</td>
                                <td>{{$deposit->check_number}}</td>
                                <td>{{ view_date_format($deposit->date) }}</td>
                                <td>{{$deposit->note}}</td>
                                <td>
                                    @if ($deposit->attachment)
                                    <a class="btn btn-sm btn-info" href="{{ asset($deposit->attachment) }}" target="_blank">Attachment</a>
                                    @else
                                        N/A
                                    @endif
                                </td>
                                <td class="d-flex justify-content-start">
                                    @can('accounting.class-wise-fees.edit')
                                    <button class="btn btn-sm btn-soft-info edit-expense-btn mr-1" data-toggle="modal"
                                        data-target="#dataEditModal" data-id="{{ $deposit->id }}"
                                        data-bank_account_id="{{ $deposit->bank_account_id }}" data-amount="{{ $deposit->amount }}"
                                        data-date="{{ view_date_format($deposit->date) }}"
                                        data-transaction_id="{{ $deposit->transaction_id }}"  data-check_number="{{ $deposit->check_number }}"
                                        data-account_number="{{ $deposit->account_number }}"
                                        data-note="{{ $deposit->note }}">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    @endcan
                                    @can('accounting.class-wise-fees.delete')
                                        <form action="{{ route('bank_deposit.destroy', [$deposit->id]) }}"
                                            method="POST"
                                            onsubmit="return confirm('Are you sure you want to delete this')"
                                            style="display:inline-block;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                        </form>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- create Modal -->
<div class="modal fade" id="dataStoreModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id='myForm' method="POST" action="{{ route('bank_deposit.store') }}" enctype="multipart/form-data">
                @csrf
                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel">Add Bank Amount Deposit</h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="bank_account_id ">Bank Account <span class="text-danger">*</span></label>
                                <select class="form-control form-control-sm bank_account_id" name="bank_account_id" id="bank_account_id" required>
                                    <option value="">-- Select Bank Account --</option>
                                    @foreach ($bankAccounts as $key=> $value)
                                    <option value="{{$key}}">{{$value}}</option>
                                    @endforeach
                                </select>
                                @error('amount')
                                    <span class="invalid-feedback" role="alert">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="amount">Amount <span class="text-danger">*</span></label>
                                <input id="amount" type="number" min="0" required class="form-control form-control-sm @error('transaction_id') is-invalid @enderror" name="amount" value="{{ old('amount') }}" placeholder="Enter Amount">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="transaction_id">Transaction ID</label>
                                <input id="transaction_id" type="text" class="form-control form-control-sm @error('transaction_id') is-invalid @enderror" name="transaction_id" value="{{ old('transaction_id') }}" placeholder="Enter Transaction ID">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="check_number">Check Number</label>
                                <input id="check_number" type="text" class="form-control form-control-sm @error('check_number') is-invalid @enderror" name="check_number" value="{{ old('check_number') }}" placeholder="Enter Check Numbr">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date">Date </label>
                                <input id="date" type="text" class="form-control form-control-sm date3601 @error('date') is-invalid @enderror" name="date" value="{{ old('date') ?? date('Y-m-d') }}" >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="attachment">Attachment</label>
                                <div class="custom-file">
                                    <input type="file" name="attachment" class="custom-file-input" id="customFile">
                                    <label class="custom-file-label form-control-sm" for="customFile" id="customFileLabel">Choose file</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="note">Note</label>
                                <textarea name="note" id="note" class="form-control form-control-sm" rows="3"></textarea>
                                @error('note')
                                    <span class="invalid-feedback" role="alert">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->
<!--edit Modal -->
<div class="modal fade" id="dataEditModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id='myForm2' method="POST" action="{{ route('bank_deposit.update') }}" enctype="multipart/form-data">
                @csrf
                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel2">Edit Bank Amount Deposit</h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <input type="hidden" id="id" name="id">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="bank_account_id_edit ">Bank Account <span class="text-danger">*</span></label>
                                <select class="form-control form-control-sm bank_account_id" name="bank_account_id" id="bank_account_id_edit" required>
                                    <option value="">-- Select Bank Account --</option>
                                    @foreach ($bankAccounts as $key=> $value)
                                    <option value="{{$key}}">{{$value}}</option>
                                    @endforeach
                                </select>
                                @error('amount')
                                    <span class="invalid-feedback" role="alert">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="amount_edit">Amount <span class="text-danger">*</span></label>
                                <input id="amount_edit" type="number" min="0" required class="form-control form-control-sm @error('transaction_id') is-invalid @enderror" name="amount" value="{{ old('amount') }}" placeholder="Enter Amount">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="transaction_id_edit">Transaction ID</label>
                                <input id="transaction_id_edit" type="text" class="form-control form-control-sm @error('transaction_id') is-invalid @enderror" name="transaction_id" value="{{ old('transaction_id') }}" placeholder="Enter Transaction ID">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="check_number_edit">Check Number</label>
                                <input id="check_number_edit" type="text" class="form-control form-control-sm @error('check_number') is-invalid @enderror" name="check_number" value="{{ old('check_number') }}" placeholder="Enter Check Numbr">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date_edit">Date </label>
                                <input id="date_edit" type="text" class="form-control form-control-sm date3603 @error('date') is-invalid @enderror" name="date" value="{{ old('date') }}" >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="attachment">Attachment</label>
                                <div class="custom-file">
                                    <input type="file" name="attachment" class="custom-file-input" id="customFile">
                                    <label class="custom-file-label form-control-sm" for="customFile" id="customFileLabel">Choose file</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="note_edit">Note</label>
                                <textarea name="note" id="note_edit" class="form-control form-control-sm" rows="3"></textarea>
                                @error('note')
                                    <span class="invalid-feedback" role="alert">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->

@endsection
@section('scripts')
        <script type="text/javascript">
            const today = new Date();
            $('.date3601').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                todayHighlight: true,
            }).datepicker('setDate', today);

            $('.date3603').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                todayHighlight: true,
            })

            $('#dataEditModal').on('hidden.bs.modal', function () {
                // Reset the form inside the modal
                $(this).find('form')[0].reset();
                // Optionally, reset specific fields manually (in case you're setting them dynamically)
                $(this).find('.form-control').val('');
                $(this).find('.form-control-sm').val('');
            });

            $('#dataEditModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget)
                var id = button.data('id')
                var bank_account_id = button.data('bank_account_id')
                var amount = button.data('amount')
                var date = button.data('date')
                var transaction_id = button.data('transaction_id')
                var check_number = button.data('check_number')
                var account_number = button.data('account_number')
                var note = button.data('note')
                var modal = $(this)
                // Populate the modal fields with data only if they are empty
                if (!modal.find('#id').val()) {
                    modal.find('#id').val(id)
                }
                if (!modal.find('#bank_account_id_edit').val()) {
                    modal.find('#bank_account_id_edit').val(bank_account_id)
                }
                if (!modal.find('#amount_edit').val()) {
                    modal.find('#amount_edit').val(amount)
                }
                if (!modal.find('#note_edit').val()) {
                    modal.find('#note_edit').val(note)
                }
                // if (!modal.find("#note_edit").val()) {
                //     var noteValue = note.replace(/"/g, '\\"'); // Escape quotes if needed
                //     modal.find("#note_edit option[value='" + noteValue + "']").prop("selected", true);
                // }
                if (!modal.find('#date_edit').val()) {
                    modal.find('#date_edit').val(date)
                }
                if (!modal.find('#transaction_id_edit').val()) {
                    modal.find('#transaction_id_edit').val(transaction_id)
                }
                if (!modal.find('#check_number_edit').val()) {
                    modal.find('#check_number_edit').val(check_number)
                }
                if (!modal.find('#account_number_edit').val()) {
                    modal.find('#account_number_edit').val(account_number)
                }
            });
        </script>
    @endsection
