@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
    @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6 class="m-0 table__top__txt">Check Book</h6>
                <div class="m-0 float-right">
                    <button class="btn btn-sm btn-light-blue" data-toggle="modal" data-target="#dataStoreModal">Add New</button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table" id="dataTable">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Account Name</th>
                                <th>Account No</th>
                                <th>Routing No</th>
                                <th>Total Page</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $sn = 0;
                            @endphp
                            @foreach($checkBooks as $checkBook)
                                <tr>
                                    <td>{{ ++$sn }}</td>
                                    <td>{{ $checkBook->name }}</td>
                                    <td>{{ $checkBook->account_no }}</td>
                                    <td>{{ $checkBook->routing_no }}</td>
                                    <td>{{ $checkBook->total_page }}</td>
                                    <td class="d-flex justify-content-start">
                                        <button class="btn btn-sm btn-soft-info edit-expense-btn mr-1" data-toggle="modal"
                                            data-target="#dataEditModal" data-id="{{ $checkBook->id }}"
                                            data-name="{{ $checkBook->name }}" data-account_no="{{ $checkBook->account_no }}"
                                            data-routing_no="{{ $checkBook->routing_no }}"  data-total_page="{{ $checkBook->total_page }}">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <form action="{{ route('check-books.destroy', $checkBook->id) }}" method="post">
                                            @csrf
                                            @method('DELETE')
                                            <button onclick="return confirm('Are you sure you want to delete this')" class="btn btn-sm btn-soft-danger" type="submit"><i class="fas fa-trash"></i></button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- create Modal -->
<div class="modal fade" id="dataStoreModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id='myForm' method="POST" action="{{ route('check-books.store') }}">
                @csrf
                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel">Add Check Book</h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Name <span class="text-danger">*</span></label>
                                <input type="text" id="name" class="form-control form-control-sm" name="name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="account_no">Account No <span class="text-danger">*</span></label>
                                <input type="text" id="account_no" class="form-control form-control-sm" name="account_no" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="routing_no">Routing No <span class="text-danger">*</span></label>
                                <input type="text" id="routing_no" class="form-control form-control-sm" name="routing_no" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="total_page">Total Page <span class="text-danger">*</span></label>
                                <input type="number" id="total_page" class="form-control form-control-sm" name="total_page" required>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->
<!--edit Modal -->
<div class="modal fade" id="dataEditModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id='myForm2' method="POST" action="{{ route('check-books.update') }}">
                @csrf
                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel2">Edit Check Book </h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <input type="hidden" id="id" name="id">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name_edit">Name <span class="text-danger">*</span></label>
                                <input type="text" id="name_edit" class="form-control form-control-sm" name="name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="account_no_edit">Account No <span class="text-danger">*</span></label>
                                <input type="text" id="account_no_edit" class="form-control form-control-sm" name="account_no" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="routing_no_edit">Routing No <span class="text-danger">*</span></label>
                                <input type="text" id="routing_no_edit" class="form-control form-control-sm" name="routing_no" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="total_page_edit">Total Page <span class="text-danger">*</span></label>
                                <input type="number" id="total_page_edit" class="form-control form-control-sm" name="total_page" required>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->
@endsection
@section('scripts')
        <script type="text/javascript">
            $('#dataEditModal').on('hidden.bs.modal', function () {
                // Reset the form inside the modal
                $(this).find('form')[0].reset();
                // Optionally, reset specific fields manually (in case you're setting them dynamically)
                $(this).find('.form-control').val('');
                $(this).find('.form-control-sm').val('');
            });

            $('#dataEditModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget)
                var id = button.data('id')
                var name = button.data('name')
                var account_no = button.data('account_no')
                var routing_no = button.data('routing_no')
                var total_page = button.data('total_page')
                var modal = $(this)
                // Populate the modal fields with data only if they are empty
                if (!modal.find('#id').val()) {
                    modal.find('#id').val(id)
                }
                if (!modal.find('#name_edit').val()) {
                    modal.find('#name_edit').val(name)
                }
                if (!modal.find('#account_no_edit').val()) {
                    modal.find('#account_no_edit').val(account_no)
                }
                if (!modal.find('#routing_no_edit').val()) {
                    modal.find('#routing_no_edit').val(routing_no)
                }
                if (!modal.find('#total_page_edit').val()) {
                    modal.find('#total_page_edit').val(total_page)
                }
            });
        </script>
    @endsection
