@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        @if ($errors->any())
            <div class="alert alert-warning m-3" role="alert">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6 class="m-0 table__top__txt">Copy Class Fees for next year. </h6>
                <a href="{{ route('class_fees.index') }}" class="btn btn-sm btn-secondary">Back</a>
            </div>
            <div class="card-body">
                <form action="{{ route('class_fees.store') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            <div class="form-group">
                                <label for="class_id">Student Class</label>
                                {{ generateDropdown($classes, 'class="form-control select2 student_class_id" id="student_class_id" name="student_class_id" required', Route::current()->parameter('student_class_id') ?? '', "Select Class") }}
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            <div class="form-group">
                                <label for="academic_year_id">Academic Year</label>
                                {{ generateDropdown($years, 'class="form-control select2 academic_year_id" id="academic_year_id" name="academic_year_id" required', '', "Select Year") }}
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Select</th>
                                    <th>Fee Category</th>
                                    <th>Effective Month</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($feeTypes as $feeType)
                                    <tr>
                                        <td>
                                            <input type="checkbox" name="fee_type_id[]" value="{{ $feeType->id }}"
                                            {{ array_key_exists($feeType->id, $selectedFeeTypes) ? 'checked' : '' }}>
                                        </td>
                                        <td>{{ $feeType->title }}</td>
                                        <td>{{$feeType->month ? $months[$feeType->month] : '--'}}</td>
                                        <td>
                                            @php
                                                $inputEnable = array_key_exists($feeType->id, $selectedFeeTypes) ? '' : 'disabled';
                                                $amount = array_key_exists($feeType->id, $selectedFeeTypes) ? $selectedFeeTypes[$feeType->id] : '';
                                            @endphp
                                            <input type="number" name="amount[{{$feeType->id}}]" class="form-control form-control-sm"
                                                value="{{ $amount }}" {{$inputEnable}}
                                                placeholder="Enter amount">
                                            <input type="hidden" name="month[{{$feeType->id}}]" value="{{$feeType->month ?? ''}}">
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <button type="submit" class="btn btn-primary">Copy</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
    <script>
        $('#tution_fee').on('keyup',function () {
            $('.TUITION').val($(this).val());
        });
        document.querySelectorAll('input[type="checkbox"]').forEach(checkbox => {
            checkbox.addEventListener('change', function() {
                const amountInput = this.closest('tr').querySelector('input[type="number"]');
                amountInput.disabled = !this.checked;
                if (!this.checked) {
                    amountInput.value = '';
                }
            });
        });
    </script>
@endsection
