


========================create.blade===================================
@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        @if ($errors->any())
            <div class="alert alert-warning m-3" role="alert">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6 class="m-0 table__top__txt">Add Class Fees</h6>
                <a href="{{ route('class_fees.index') }}" class="btn btn-sm btn-primary">Class Fees</a>
            </div>
            <div class="card-body">
                <form action="{{ route('class_fees.store') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            <div class="form-group">
                                <label for="student_class_id">Student Class <span class="text-danger">*</span></label>
                                {{ generateDropdown($classes, 'class="form-control select2 student_class_id" id="student_class_id" name="student_class_id" required', '', "Select Class") }}
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            <div class="form-group">
                                <label for="department_id">Department <span class="text-danger">*</span></label>
                                {{ generateDropdown($departments, 'class="form-control select2 department_id" id="department_id" name="department_id" required', '', "Select Department") }}
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            <div class="form-group">
                                <label for="year_id">Academic Year <span class="text-danger">*</span></label>
                                {{ generateDropdown($years, 'class="form-control select2" name="academic_year_id" required', $defaultYear, "Select Year") }}
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            <div class="form-group">
                                <label for="monthly_tuition">Monthly Tutuion Fees</label>
                                <input type="text" id="tution_fee" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <table class="table table-bordered" id="feeTypeTable">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="selectAll"> Select All</th>
                                    <th>Fee Category</th>
                                    <th>Effective Month</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($feeTypes as $feeType)
                                    <tr>
                                        <td>
                                            @if ($feeType->code=='Tuition')
                                                <input type="checkbox" class="feeTypeCheckbox" name="fee_type_id[]" value="{{ $feeType->id }}" checked>
                                            @else
                                                <input type="checkbox" class="feeTypeCheckbox" name="fee_type_id[]" value="{{ $feeType->id }}">
                                            @endif
                                        </td>
                                        <td>{{ $feeType->title }}</td>
                                        <td>{{$feeType->month ? $months[$feeType->month] : '--'}}</td>
                                        <td>
                                            @if ($feeType->code=='Tuition')
                                                <input type="number" min="0" name="amount[{{$feeType->id}}]" class="form-control amountInput {{ $feeType->code }}" placeholder="Enter amount">
                                            @else
                                                <input type="number" min="0" name="amount[{{$feeType->id}}]" class="form-control amountInput {{ $feeType->code }}" placeholder="Enter amount" disabled>
                                            @endif
                                            <input type="hidden" min="0" name="month[{{$feeType->id}}]" value="{{$feeType->month ?? ''}}">
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <button type="submit" class="btn btn-primary">Add</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
    <script>
        $(document).ready(function () {
            $('#tution_fee').on('keyup',function () {
                $('.Tuition').val($(this).val());
            });
            // Select All checkbox change event
            $('#selectAll').change(function () {
                if (this.checked) {
                    // Check all checkboxes in the table body
                    $('.feeTypeCheckbox').prop('checked', true);
                } else {
                    // Uncheck all checkboxes in the table body
                    $('.feeTypeCheckbox').prop('checked', false);
                }
                updateInputStates(); // Update input states after checkbox change
            });
            // Individual checkbox change event
            $('.feeTypeCheckbox').change(function () {
                // Check if all checkboxes are checked
                if ($('.feeTypeCheckbox:checked').length === $('.feeTypeCheckbox').length) {
                    $('#selectAll').prop('checked', true);
                } else {
                    $('#selectAll').prop('checked', false);
                }
                updateInputStates(); // Update input states after checkbox change
            });
            // Function to update input states based on checkbox state
            function updateInputStates() {
                $('.feeTypeCheckbox').each(function () {
                    const amountInput = $(this).closest('tr').find('.amountInput');
                    amountInput.prop('disabled', !this.checked);
                    if (!this.checked) {
                        amountInput.val(''); // Clear input value if checkbox is unchecked
                    }
                });
            }
        });
    </script>
@endsection


========================show.blade===================================
@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        <div class="card">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6 class="m-0 table__top__txt">Class Fees</h6> 
                <span>
                    @php
                        $class_details = $fee_details->first();
                    @endphp
                    <b>Class :</b> {{$class_details->class_name}}, 
                    <b>Department :</b> {{$class_details->department_name}}, 
                    <b>Year :</b> {{$class_details->year}}
                </span>
                @can('accounting.class-wise-fees.create')
                    <div class="m-0 float-right">
                        <a href="{{ route('class_fees.index') }}" class="btn btn-sm btn-primary">Class Fees</a>
                    </div>
                @endcan
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table" >
                            <thead class="thead-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Fee Category</th>
                                    <th>Effective Month</th>
                                    <th>Fee Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $sn = 0;
                                @endphp
                                @foreach ($fee_details as $fees)
                                    <tr>
                                        <td>{{ ++$sn }}</td>
                                        <td>{{ $fees->fee_type_title }}</td>
                                        <td>{{$months[$fees->month]}}</td>
                                        <td>{{ $fees->amount }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
