@extends('layouts.master')

@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        <div class="card">
            <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6 class="m-0 table__top__txt">Class Fees</h6>
                @can('accounting.class-wise-fees.create')
                <a href="{{ route('class_fees.create') }}" class="btn btn-sm btn-light-blue">Add New</a>
                @endcan
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table" id="dataTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Class</th>
                                    <th>Academic Year</th>
                                    <th>Total Fees</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>

                            <tbody>
                                @php
                                    $sn = 0;
                                @endphp
                                @foreach ($classFees as $fees)
                                    <tr>
                                        <td>{{ ++$sn }}</td>
                                        <td>{{$fees->class_name}}</td>
                                        <td>{{$fees->year}}</td>
                                        <td>{{$fees->amount}}</td>
                                        <td class="d-flex justify-content-start">
                                            @php
                                                $routeParam = "$fees->student_class_id/$fees->academic_year_id";
                                            
                                            @endphp
                                            <a href="{{ URL("accounting/class-fees/view/$routeParam") }}" class="btn btn-sm btn-soft-success mr-1"><i class="fas fa-eye"></i></a>
                                            @can('accounting.class-wise-fees.edit')
                                                <a href="{{ URL("accounting/class-fees/edit/$routeParam") }}" class="btn btn-sm btn-soft-info mr-1"><i class="fas fa-edit"></i></a>
                                                {{-- <a href="{{ URL("accounting/class-fees/copy/$routeParam") }}" class="btn btn-sm btn-soft-success"><i class="fas fa-copy"></i></a> --}}
                                            @endcan
                                            @can('accounting.class-wise-fees.delete')
                                                <form action="{{ URL("accounting/class-fees/delete/$routeParam") }}"
                                                    method="POST"
                                                    onsubmit="return confirm('Are you sure you want to delete this')"
                                                    style="display:inline-block;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                                </form>
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
