@extends('layouts.master')
@section('content')
<style>
    /* Chrome, Safari, Edge, Opera */
    input[type="number"]::-webkit-outer-spin-button,
    input[type="number"]::-webkit-inner-spin-button {
        -webkit-appearance: none;
        margin: 0;
    }
    /* Firefox */
    input[type="number"]{
        -moz-appearance: textfield;
    }
</style>
<div class="fee__setup">
    <div class="col-md-12 col-xl-12 col-xxl-12 m-auto">
        <div class="card">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6 class="m-0 table__top__txt">Class Fees</h6> 
                <span>
                    @php
                        $class_details = $fee_details->first();
                    @endphp
                    <b>Class :</b> {{$class_details->class_name}},  
                    <b>Year :</b> {{$class_details->year}}
                </span>
                @can('accounting.class-wise-fees.create')
                    <div class="m-0 float-right">
                        <a href="{{ route('class_fees.index') }}" class="btn btn-sm btn-light-blue">Class Fees</a>
                    </div>
                @endcan
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="thead-light">
                                <tr>
                                    <th width="180" style="color: var(--light-blue-active) !important">Fee Type</th>
                                    @for ($i = 1; $i <= 12; $i++)
                                        <th class="text-center">{{ DateTime::createFromFormat('!m', $i)->format('M') }}</th>
                                    @endfor
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($feeTypes as $feeType)
                                    <tr>
                                        <td>{{ $feeType->title }}</td>
                                        @for ($i = 1; $i <= 12; $i++)
                                            @php
                                                $month = $i;
                                                $amount = $structuredData[$feeType->code][$month] ?? 0;
                                                $monthName = DateTime::createFromFormat('!m', $i)->format('M');
                                            @endphp
                                            <td>
                                                <input 
                                                    name="{{ $feeType->code . '_' . $monthName }}"
                                                    type="number"
                                                    min="0"
                                                    class="form-control fee-type-field @if ($feeType->code == 'Tuition') Tuition @endif"
                                                    value="{{ (int) $amount }}"
                                                    readonly
                                                >
                                            </td>
                                        @endfor
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr id="monthlyTotalRow">
                                    <td><b>Total</b></td>
                                    @for ($i = 1; $i <= 12; $i++)
                                        <td class="text-center">
                                            <b id="total_{{ DateTime::createFromFormat('!m', $i)->format('M') }}">0</b>
                                        </td>
                                    @endfor
                                </tr>
                                <tr id="grandTotalRow">
                                    <td><b>Grand Total</b></td>
                                    <td class="text-center" colspan="12">
                                        <b id="grand-total">0</b>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    function calculateMonthlyTotals() {
        const months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
        let grandTotal = 0;

        months.forEach(month => {
            let total = 0;
            document.querySelectorAll(`input[name$='_${month}']`).forEach(input => {
                const val = parseFloat(input.value) || 0;
                total += val;
            });
            document.getElementById(`total_${month}`).textContent = total;
            grandTotal += total;
        });

        document.getElementById('grand-total').textContent = grandTotal;
    }

    calculateMonthlyTotals();
</script>
@endsection