@extends('layouts.master')

@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
        <h6 class="m-0 table__top__txt">Create Expense Item</h6>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <form action="{{ route('expense-item.store') }}" method="POST">
                    @csrf
                    <div class="form-group">
                        <label for="name">Name <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="description">Description (Optional)</label>
                        <textarea name="description" class="form-control"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="expense_head_id">Expense Head <span class="text-danger">*</span></label>
                        <select name="expense_head_id" class="form-control" required>
                            <option value="">Select Expense Head</option>
                            @foreach ($expenseHeads as $expenseHead)
                                <option value="{{ $expenseHead->id }}">{{ $expenseHead->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <button type="submit" class="btn btn-submit">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
