@extends('layouts.master')

@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
        <h6 class="m-0 table__top__txt">Edit Expense Item</h6>
    </div>
    <div class="card-body">
        <form action="{{ route('expense-item.update', $expenseItem) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label for="name">Name</label>
                <input type="text" name="name" class="form-control" value="{{ $expenseItem->name }}" required>
            </div>
            <div class="form-group">
                <label for="description">Description</label>
                <textarea name="description" class="form-control">{{ $expenseItem->description }}</textarea>
            </div>
            <div class="form-group">
                <label for="expense_head_id">Expense Head</label>
                <select name="expense_head_id" class="form-control">
                    @foreach ($expenseHeads as $expenseHead)
                        <option value="{{ $expenseHead->id }}" {{ $expenseItem->expense_head_id == $expenseHead->id ? 'selected' : '' }}>{{ $expenseHead->name }}</option>
                    @endforeach
                </select>
            </div>
            <button type="submit" class="btn btn-success">Update</button>
        </form>
    </div>
</div>
@endsection 
