@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-xl-12 col-xxl-10 m-auto">
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6 class="m-0 table__top__txt">Expense List</h6>
                <div class="m-0 float-right">
                    @can('accounting.expense.create')
                        <button class="btn btn-sm btn-light-blue" id="add-expense-btn" data-toggle="modal" data-target="#dataStoreModal">Add New</button>
                    @endcan
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table" id="dataTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Head</th>
                                    <th>Invoice No</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                    <th>Note</th>
                                    <th>Attachment</th>
                                    {{-- <th>Payment method</th> --}}
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $sn = 0; @endphp
                                @foreach($expenses as $expense)
                                    <tr>
                                        <td>{{ ++$sn }}</td>
                                        <td>{{ $expenseHeads[$expense->accounting_head_id] ?? 'N/A' }}</td>
                                        <td>{{ $income->invoice_no ?? '' }}</td>
                                        <td>{{ $expense->amount ?? ''}}</td>
                                        <td>{{ view_date_format($expense->expense_date) ?? 'N/A' }}</td>
                                        <td>{{ $expense->description ?? 'N/A' }}</td>
                                        <td>
                                            @if ($expense->attachment)
                                                <a class="btn btn-sm btn-info" href="{{ asset($expense->attachment) }}" target="_blank">Attachment</a>
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        {{-- <td>{{ $expense->payment_method ?? "N/A" }}</td> --}}
                                        <td class="d-flex justify-content-start">
                                            @can('accounting.expense.edit')
                                                <button class="btn btn-sm btn-soft-info edit-expense-btn mr-1" data-toggle="modal"
                                                    data-target="#dataEditModal" data-id="{{ $expense->id }}"
                                                    data-accounting_head_id="{{ $expense->accounting_head_id }}" data-amount="{{ $expense->amount }}"
                                                    data-expense_date="{{ view_date_format($expense->expense_date) }}" data-description="{{ $expense->description }}"
                                                    data-invoice_no="{{ $expense->invoice_no }}" data-attachment="{{ $expense->attachment ? asset($expense->attachment) : '' }}"
                                                    data-payment_method="{{ $expense->payment_method }}"
                                                >
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                            @endcan
                                            <a href="{{ route('expense.print', $expense->id) }}" target="_blank" class="btn btn-soft-secondary btn__export mr-1">
                                                <i class="fas fa-print"></i>
                                            </a>
                                            @can('accounting.expense.delete')
                                                <form action="{{ route('expense.destroy', $expense->id) }}" method="POST" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure?')"><i class="fas fa-trash"></i></button>
                                                </form>
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- create Modal -->
<div class="modal fade" id="dataStoreModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" method="POST" action="{{ route('expense.store') }}" enctype="multipart/form-data">
                @csrf
                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel">Add Expense</h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <div class="form-group">
                        <label for="accounting_head_id">Expense Head <span class="text-danger">*</span></label>
                        {{ generateDropdown($expenseHeads, 'name="accounting_head_id" class="form-control form-control-sm" id="accounting_head_id" required', old('accounting_head_id'), '--Secect Head--' ) }}
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="amount">Amount <span class="text-danger">*</span></label>
                                <input type="number" name="amount" class="form-control form-control-sm" id="amount" placeholder="Enter amount" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="expense_date">Expense Date <span class="text-danger">*</span></label>
                                <input type="text" name="expense_date" class="form-control form-control-sm date3601" id="expense_date" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        {{-- <div class="col-md-6">
                            <div class="form-group">
                                <label for="invoice_no">Invoice No</label>
                                <input type="text" name="invoice_no" class="form-control form-control-sm" id="invoice_no" placeholder="Enter Invoice No">
                            </div>
                        </div> --}}
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="attachment">Attachment</label>
                                <input type="file" name="attachment" class="form-control form-control-sm" id="attachment">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="description">Note</label>
                        <textarea name="description" cols="30" rows="2" class="form-control form-control-sm" id="description" placeholder="Enter Note"></textarea>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->
<!--edit Modal -->
<div class="modal fade" id="dataEditModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" method="POST" action="{{ route('expense.update') }}" enctype="multipart/form-data">
                @csrf
                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel2">Edit Expense </h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <input type="hidden" id="id" name="id">
                    <div class="form-group">
                        <label for="accounting_head_id_edit">Expense Head <span class="text-danger">*</span></label>
                        {{ generateDropdown($expenseHeads, 'name="accounting_head_id" class="form-control form-control-sm" id="accounting_head_id_edit" required', old('accounting_head_id'), '--Secect Head--' ) }}
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="amount_edit">Amount <span class="text-danger">*</span></label>
                                <input type="number" name="amount" class="form-control form-control-sm" id="amount_edit" placeholder="Enter amount" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="expense_date_edit">Expense Date <span class="text-danger">*</span></label>
                                <input type="text" name="expense_date" class="form-control form-control-sm date3603" id="expense_date_edit" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        {{-- <div class="col-md-6">
                            <div class="form-group">
                                <label for="invoice_no_edit">Invoice No</label>
                                <input type="text" name="invoice_no" class="form-control form-control-sm" id="invoice_no_edit" placeholder="Enter Invoice No">
                            </div>
                        </div> --}}
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="attachment_edit">Attachment</label>
                                <input type="file" name="attachment" class="form-control form-control-sm" id="attachment_edit">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="description_edit">Note</label>
                        <textarea name="description" cols="30" rows="2" class="form-control form-control-sm" id="description_edit" placeholder="Enter Note"></textarea>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->
@stop
@section('scripts')
<script>
    $(document).ready(function () {
        const today = new Date();
        $('.date3601').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true,
        }).datepicker('setDate', today);
        $('.date3603').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true,
        })

        $('#dataEditModal').on('hidden.bs.modal', function () {
            // Reset the form inside the modal
            $(this).find('form')[0].reset();
            // Optionally, reset specific fields manually (in case you're setting them dynamically)
            $(this).find('.form-control').val('');
            $(this).find('.form-control-sm').val('');
        });

        $('#dataEditModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget)
            var accounting_head_id = button.data('accounting_head_id')
            var amount = button.data('amount')
            var expense_date = button.data('expense_date')
            var description = button.data('description')
            var invoice_no = button.data('invoice_no')
            var payment_method = button.data('payment_method')
            var id = button.data('id')
            var modal = $(this)
            if (!modal.find('#amount_edit').val()) {
                modal.find('#amount_edit').val(amount)
            }
            if (!modal.find("#accounting_head_id_edit").val()) {
                modal.find("#accounting_head_id_edit option[value=" + accounting_head_id + "]").prop("selected", true);
            }
            if (!modal.find('#expense_date_edit').val()) {
                modal.find('#expense_date_edit').val(expense_date)
            }
            if (!modal.find('#description_edit').val()) {
                modal.find('#description_edit').val(description)
            }
            if (!modal.find('#invoice_no_edit').val()) {
                modal.find('#invoice_no_edit').val(invoice_no)
            }
            if (!modal.find('#id').val()) {
                modal.find('#id').val(id)
            }
        });
    });
</script>
@endsection
