@extends('layouts.master')
@section('content')

<style>
        body {
            font-family: sans-serif;
        }

        p {
            margin-top: 0;
            margin-bottom: 10px;
        }

        .invoice_header .content h2 {
            margin-top: 0;
            margin-bottom: 12px;
            font-size: 21px;
            font-weight: 700;
        }

        .invoice_header .content p {
            margin-bottom: 5px;
            font-weight: 300;
            color: #5a5a5a;
            font-size: 15px;
        }

        .invoice_header {
            display: flex;
        }

        .invoice_header .img {
            width: 25%;
        }

        .invoice_header .img img {
            width: 160px;
            height: 114px;
        }

        .invoice_header .content {
            color: black;
            width: 75%;
        }
        

        .invoice_footer .title_message {
            text-align: center;
            margin-top: 0;
            font-family: cursive;
            color: black;
            margin-bottom: 7px;
            font-size: 13px;
        }

        .invoice_footer .powerby {
            color: #747474;
            font-size: 12px;
            font-weight: 300;
            text-align: center;
            background: #eee;
            padding: 5px;
            line-height: 1;
        }

        .invoice_footer .powerby span {
            color: black;
            letter-spacing: .5px;
            font-weight: bold;
        }

        .invoice_content {
            width: 100%;
            max-width: 210mm;
            margin: 0px auto 2.5em;
            padding: 20px;
            border: 1px dotted #ccc;
            background-color: #fff;
        }

        .invoice_body {
            padding: 15px 0;
        }

        .invoice_body .head {
            padding: 15px;
            border: 1px solid #ededed;
            display: flex;
            margin-bottom: 15px;
            background-color: #f5f5f5b8;
        }

        .invoice_body .head .left {
            width: 50%;
            text-align: left;
            color: black;
        }

        .invoice_body .head .right p,
        .invoice_body .head .left p {
            margin-bottom: 7px;
            margin-top: 0;
            font-size: 15px;
        }

        .invoice_body .head .right {
            width: 50%;
            text-align: right;
            color: black;
        }
        .invoice_body .foot {
            display: flex;
        }

        .invoice_body .foot .prepared_by {
            width: 35%;
            text-align: center;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
        }
        .info-table td {
            padding: 8px;
            border: 1px solid #ddd;
        }
        .info-table th, .info-table td{
            padding: 8px;
            border: 1px solid #ddd;text-align: center;
        }
        .info-table th {
            font-weight: bold;
            width: 200px;
        }

        .invoice_body .right span {
            font-weight: 700;
            font-size: 28px;
            color: green;
        }

        @media print {
            .invoice_content {
                margin: 0;
                border: none;
                background-color: #fff;
            }

            #invoice {
                padding: 20px;
            }

            @page {
                size: A5;
                margin: 0;
            }

            body {
                margin: 0;
            }
        }
    </style>


@if (isset($expense) && !empty($expense))

        @php
            $get_branch_info = get_branch_info();
            $logo = get_setting_value(Settings::EXPORT_LOGO) ? asset(get_setting_value(Settings::EXPORT_LOGO)) : asset('default/default.png');
            $principal_signature = get_setting_value(Settings::PRINCIPAL_SIGNATURE) ? asset(get_setting_value(Settings::PRINCIPAL_SIGNATURE)) : '';
        @endphp
        
        <div class="card p-1 invoice">
            <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
                <button class="btn btn-success btn-sm" onclick="closeWindow()">Back</button>
                <button class="btn btn-success btn-sm" onclick="printInv()">Print</button>
            </div>
            <div class="card-body mt-4 invoice_content">
                <div class="invoice_header">
                    <div class="img">
                        <img src="{{ asset($logo) }}" alt="Logo">
                    </div>
                    <div class="content">
                        <h2>{{get_setting_value(Settings::SCHOOL_NAME)}}</h2>
                        <p>{{$get_branch_info->address}}</p>
                        <p>Contact: {{$get_branch_info->contact_info}}</p>
                        <p>Email: {{get_setting_value(Settings::SCHOOL_EMAIL)}}</p>
                        <p><strong>Expense Receipt</strong></p>
                    </div>
                </div>
                <div class="invoice_body">
                    <div class="head">
                        <div class="left">
                            <p><b>Invoice No: {{ $expense->invoice_no }}</b></p>
                        </div>
                        <div class="right">
                            <p>Date: {{ view_date_format($expense->expense_date) }}</p>
                            <span>PAID</span>
                        </div>
                    </div>
                    <div class="body">

                        <table class="info-table">
                            <thead>
                                <tr>
                                    <th>Description</th>
                                    <th>Payment Method</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{!! $expense->accountingHead->name . (!empty($expense->description) ? '<br>' . $expense->description : '') !!}</td>
                                    <td>{{ $expense->payment_method ?? 'N/A' }}</td>                                    
                                    <td>{{ number_format($expense->amount, 2) }} Tk</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="invoice_footer">
                    <div class="powerby">
                        <div class="title_message">Thank you for your payment</div>
                        Powered By <span>EduEasy</span>
                    </div>
                </div>
                
                
            </div>
        </div>
    @endif

@endsection 
@section('scripts')
    <script>
        // let print_preview = "{{ isset($print_preview) ? $print_preview : '' }}";
        // if (print_preview == 'yes') {
            printInv();
        // }
        function printInv() {
            let htmlToPrint = '';
            // let divToPrint = document.getElementById('invoice');
            let divToPrint = document.getElementsByClassName("invoice_content");

            const newWin = window.open("");

            htmlToPrint = `<style type="text/css" media="print">
                        @page { size: a5; }
                        .invoice_content{
                            visibility: ;
                        }
                        body{
                            font-family: sans-serif;
                            font-style: normal;
                            // max-width: 450px;
                            height: 210mm;
                            width: 148.5mm;
                            margin: 0;
                            -webkit-print-color-adjust: exact;
                        }


                        p{
                            margin-top: 0;
                            margin-bottom: 10px;
                        }
                        .invoice_header .content h2{
                            margin-top: 0;
                            margin-bottom: 12px;
                            font-size: 21px;
                            font-weight: 700;
                        }
                        .invoice_header .content p{
                            margin-bottom: 5px;
                            font-weight: 300;
                            color: #5a5a5a;
                            font-size: 15px;
                        }
                        .invoice_header {
                            display: flex;
                        }
                        .invoice_header .img {
                            width: 35%;
                        }
                        .invoice_header .img img {
                            width: 160px;
                            height: 114px;
                        }
                        .invoice_header .content {
                            color: black;
                            width: 65%;
                        }

                        .invoice_footer .title_message {
                            text-align: center;
                            margin-top: 0;
                            font-family: cursive;
                            color: black;
                            margin-bottom: 7px;
                            font-size: 13px;
                        }

                        .invoice_footer .powerby {
                            color: #747474;
                            font-size: 12px;
                            font-weight: 300;
                            text-align: center;
                            background: #eee;
                            padding: 5px;
                            line-height: 1;
                        }

                        .invoice_footer .powerby span {
                            color: black;
                            letter-spacing: .5px;
                            font-weight: bold;
                        }

                        .invoice_content {
                            width: 100%;
                            max-width: 210mm;
                            margin: 0px auto 2.5em;
                            padding: 20px;
                            border: 1px dotted #ccc;
                            background-color: #fff;
                        }

                        .invoice_body {
                            padding: 15px 0;
                        }

                        .invoice_body .head {
                            padding: 15px;
                            border: 1px solid #ededed;
                            display: flex;
                            margin-bottom: 15px;
                            background-color: #f5f5f5b8;
                        }

                        .invoice_body .head .left {
                            width: 50%;
                            text-align: left;
                            color: black;
                        }

                        .invoice_body .head .right p,
                        .invoice_body .head .left p {
                            margin-bottom: 7px;
                            margin-top: 0;
                            font-size: 15px;
                        }

                        .invoice_body .head .right {
                            width: 50%;
                            text-align: right;
                            color: black;
                        }
                        .invoice_body .foot {
                            display: flex;
                        }

                        .invoice_body .foot .prepared_by {
                            width: 35%;
                            text-align: center;
                        }
                        .info-table {
                            width: 100%;
                            border-collapse: collapse;
                        }

                        .info-table th, .info-table td{
                            padding: 8px;
                            border: 1px solid #ddd;
                        }
                        .info-table th {
                            font-weight: bold;
                            width: 200px;
                        }
                        .info-table td {
                            text-align: center;
                        }
                        
                        .invoice_body .right span {
                            font-weight: 700;
                            font-size: 28px;
                            color: green;
                        }
                    </style>`;

            newWin.document.write(htmlToPrint);

            newWin.document.write(divToPrint[0].outerHTML);
            newWin.document.close();
            // newWin.print();
            // newWin.close();
            setTimeout(function() {
                newWin.print();
                newWin.close();
            }, 90);
        }
        let printWindowClosed = false;

        function closeWindow() {
            if (!printWindowClosed) {
                printWindowClosed = true;
                window.close();
                if (window.opener) {
                    window.opener.focus();
                }
            }
        }
    </script>
@endsection
