15-08-2025
@extends('layouts.master')

@section('content')
    <style>
        .custom-switch-inline {
            display: inline-block;
            margin-left: 10px; /* add some space between the label and the checkbox */
        }

        .custom-switch-inline .custom-control-label {
            margin-left: 5px; /* add some space between the checkbox and the label */
        }

        .table td, .table th {
            padding: .25rem;
            vertical-align: top;
            border-top: 1px solid #e3e6f0;
        }

        .select2-selection__rendered {
            line-height: 27px !important;
        }

        .data__search .content {
            border-left: 3px solid #ff8d00;
            padding-left: 7px;
        }

        .data__search .multiselect-filter {
            display: none;
        }

        .data__search .dropdown-menu.show {
            display: block;
            width: 100%;
            padding-top: 13px;
            border-radius: 0 0 4px 4px !important;
            margin-top: -2px;
        }

        .form-control:disabled, .form-control[readonly] {
            background-color: transparent;
            opacity: 1;
            border: none;
            color: #646464;
            font-weight: 300;
            padding-left: 0;
        }

        .fee__sum .form-control:disabled, .fee__sum .form-control[readonly] {
            background-color: transparent;
            opacity: 1;
            border: none;
            color: #000;
            font-weight: 700;
            padding-left: 0;
        }

        .fee__sum {
            background: #fffcf9;
            border: 1px solid orange;
            padding: 9px;
        }

        .fee__sum label {
            margin-bottom: 0;
            color: #222222;
        }

        .fee__sum .fs__l {
            line-height: 1;
            padding: 4px 7px;
            margin-bottom: 10px;
            justify-content: space-between;
            align-items: center;
            background: #40a6dd21;
            border: 1px solid #40a6dd3d;
        }

        /*.data__search .table-bordered td, .data__search .table-bordered th {*/
        /*    border: 1px solid #fce5bf;*/
        /*}*/
    </style>

    <style>
        /*================
        Fee Collection Page
        =====================*/
        .custom-switch-inline {
            display: inline-block;
            margin-left: 10px; /* add some space between the label and the checkbox */
        }

        .custom-switch-inline .custom-control-label {
            margin-left: 5px; /* add some space between the checkbox and the label */
        }

        .table td, .table th {
            padding: .25rem;
            vertical-align: top;
            border-top: 1px solid #e3e6f0;
        }

        .select2-selection__rendered {
            line-height: 27px !important;
        }

        .data__search .content {
            border-left: 3px solid #ff8d00;
            padding-left: 7px;
        }

        .fee__sum .form-control:disabled, .fee__sum .form-control[readonly] {
            background-color: transparent;
            opacity: 1;
            border: none;
            color: #000;
            font-weight: 700;
            padding-left: 0;
            font-size: 16px;
            text-align: right;
        }

        .fee__sum {
            background: transparent;
            border: 1px solid #d1d5dd;
            padding: 9px;
        }

        .fee__sum label {
            margin-bottom: 0;
            color: #222222;
        }

        .fee__sum .fs__l {
            background: #ecf1f9;
            line-height: 1;
            padding: 4px 7px;
            margin-bottom: 10px;
            justify-content: space-between;
            align-items: center;
        }

        .fee__sum .label__fine {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        /*.data__search .table-bordered td, .data__search .table-bordered th {*/
        /*    border: 1px solid #fce5bf;*/
        /*}*/


        .fee__collection__body .card-body .table .thead-light th {
            font-weight: 500;
            font-size: 1rem;
            padding: .7rem 1.5rem;
            line-height: 1;
        }
        .fee__collection__body .card-body .table .thead-light th:last-child{
            text-align: right !important;
        }

        .fee__collection__body .custom-control-input:checked ~ .custom-control-label::before {
            color: #fff;
            border-color: #00b744;
            background-color: #00b744;
        }

        .fee__collection__body .custom-checkbox .custom-control-label::before {
            border-radius: 0px;
            top: 5px;
        }

        .fee__collection__body .table td, .table th {
            padding: .8rem 1.5rem;
            vertical-align: middle;
            border-top: 1px solid #e3e6f0;
        }

        .fee__collection__body table .tbl__footer {
            background: var(--bg-soft-pink);
        }
        .fee__collection__body table td:first-child{
            text-align: left !important;
        }
        .fee__collection__body table td:last-child{
            text-align: right !important;
        }
        .fee__collection__body table .tbl__footer td {
            font-weight: bold;
            color: var(--black);
            text-align: center !important;
        }

        .fee__collection__body table .tbl__footer td:last-child{
            text-align: right !important;
        }
    </style>

    <div class="card data__search">
        <div class="card-body card__head">
            <form action="{{ route('collect_fee.create') }}" method="GET">
                <div class="row">
                    <div class="col-md-4 col-lg-4 col-xl-2 xxl-2 mb-3 col-6">
                        <div class="form-group mb-0">
                            @component('components.search_student', [
                                'student_name' => $student_name ?? '',
                                'student_id_no' => $student_id_no ?? '',
                                'required' => 'required',
                            ])
                            @endcomponent
                        </div>
                    </div>

                    <div class="col-md-4 col-lg-4 col-xl-2 xxl-2 mb-3 col-6">
                        <div class="form-group mb-0">
                            @php
                                $selectedYear = request()->year_id ?? $defaultYear;
                                $selectedMonth = request()->month ?? [date('n')] ;
                            @endphp
                            {{ generateDropdown($years, 'name="year_id" class="form-control form-control-sm" required', $selectedYear, 'Year' ) }}
                        </div>
                    </div>
                    <div class="col-md-4 col-lg-4 col-xl-2 xxl-2 mb-3 col-6">
                        <div class="form-group mb-0">
                            {{ multiSelectDropdown($months, 'name="month[]" class="form-control form-control-sm" id="multiselect"', $selectedMonth, 'Select months...' ) }}
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="form-group mb-0">
                            <button class="btn btn-sm btn-info">Search</button>
                        </div>
                    </div>
                    @isset($student_details)

                        <div class="col-md-12">
                            <div class="content mt-3">
                                <div class="title">
                                    Student Info:
                                </div>
                                <div class="body d-flex">
                                    <div class="name mr-3">
                                        <span><b>Name:</b> {{ ($student_details->first_name ?? '') . ' ' . ($student_details->last_name ?? '') }}</span>
                                    </div>
                                    <div class="class mr-3">
                                        <span><b>Class (Section): </b>
                                            {{ $student_details->studentClass->class_name ?? '' }}
                                            @if ($student_details?->section?->section_name)
                                                ({{ $student_details?->section?->section_name }})
                                            @endif
                                        </span>
                                    </div>
                                    <div class="roll mr-3">
                                        <span><b>Roll: </b> {{ $student_details->class_roll ?? '' }}</span>
                                    </div>
                                    <div class="view">
                                        <a href="#modal"><i class="fa fa-eye"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endisset
                </div>
            </form>
        </div>
    </div>
    @if ($errors->any())
        <div class="alert alert-warning m-3" role="alert">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (isset($selectedFeeTypes) && empty($selectedFeeTypes))
        <div class="alert alert-warning m-3" role="alert">
            <h4>No Fees is setup yet for class "{{$student_details->studentClass->class_name}}"- {{$years[$year_id]}}.
                Please setup fees from <a href="{{route('class_fees.create')}}" target="_blank">here</a>.</h4>
        </div>
    @endif

    @if (isset($selectedFeeTypes) && !empty($selectedFeeTypes))
        <div class="card mt-4 data__search fee__collection__body">
            <div class="card-body">
                <form action="{{ route('collect_fee.store') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-8">
                            @isset($student_details)
                                <input type="hidden" name="student_id" value="{{ $student_details->id }}">
                                <input type="hidden" name="discount_type" value="{{ $discount?->discount_type }}">
                                <input type="hidden" name="discount" value="{{ $discount?->amount }}">
                                <input type="hidden" name="year_id" value="{{ $year_id ?? '' }}">
                                <input type="hidden" name="shift_id" value="{{ $student_details->shift_id }}">
                                <input type="hidden" name="student_class_id"
                                       value="{{ $student_details->student_class_id }}">
                                <input type="hidden" name="section_id" value="{{ $student_details->section_id }}">
                                <div class="table-responsive">
                                    <table class="table table-bordered" id="feeTypeTable">
                                        <thead class="thead-light">
                                        <tr>
                                            <th>Months</th>
                                            <th>Fee Type</th>
                                            <th class="text-center">Status</th>
                                            <th>Total Amount (Tk.)</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @if (!empty($selectedFeeTypes))

                                            @foreach($selectedFeeTypes as $fee)
                                                <tr class="subject-entry">
                                                    <td>{{ $fee['month_name'] ?? 'N/A' }}</td>
                                                    <td>
                                                        @foreach ($fee['fee_types'] as $fee_type)

                                                            @php
                                                                $uniqueKey = $fee_type['fee_type_id'] . '_' . $fee['month'];
                                                            @endphp
                                                            <span style="color: var(--black);letter-spacing: .5px;">{{ $fee_type['fee_type_name']." ".$fee_type['fee_type_amount'] }} tk;</span>

                                                            @if($fee['payment_status'] == 'Due')
                                                                <input type="hidden"
                                                                       class="custom-control-input fee-checkbox"
                                                                       id="feeCheck{{ $fee_type['fee_type_id'] }}"
                                                                       name="fee_type_id[]"
                                                                       value="{{ $fee_type['fee_type_id'] }}"
                                                                       data-month="{{ $fee['month'] }}"
                                                                       data-amount="{{ $fee_type['fee_type_amount'] }}">

                                                                <input type="hidden" name="amount[{{ $uniqueKey }}]"
                                                                       value="{{ $fee_type['fee_type_amount'] }}">
                                                                <input type="hidden" name="month[{{ $uniqueKey }}]"
                                                                       value="{{ $fee['month'] }}">
                                                            @endif

                                                        @endforeach
                                                    </td>
                                                    <td class="text-center">
                                                        @if($fee['payment_status'] == 'Due')
                                                            {!! getStatusBadge(Status::DUE) !!}
                                                        @else
                                                            {!! getStatusBadge(Status::PAID) !!}
                                                        @endif
                                                    </td>
                                                    <td class="text-center">{{ $fee['total_amount'] ?? '0.00' }}</td>
                                                </tr>
                                            @endforeach
                                            <tr class="tbl__footer">
                                                <td colspan="3"><b> Grand Total </b></td>
                                                <td> {{ $grandTotal ?? '0.00'}} </td>
                                            </tr>


                                            {{-- @foreach ($selectedFeeTypes as $month => $fees)
                                                @php
                                                    $monthName = \Carbon\Carbon::create()->month($month)->format('F');
                                                    $totalMonthAmount = 0;
                                                @endphp
                                                <tr>
                                                    <td>
                                                        <div class="control">
                                                            {{ $monthName }}
                                                        </div>
                                                    </td>
                                                    <td>
                                                        @foreach ($fees as $fee)
                                                            @php
                                                                $totalMonthAmount += $fee->amount;
                                                                 $uniqueKey = $fee->feeType->id . '_' . $month;
                                                            @endphp
                                                            <div class="control">
                                                                {{ $fee->feeType->title }} - {{ (int) $fee->amount }}
                                                                <input type="hidden" class="custom-control-input fee-checkbox" id="feeCheck{{ $fee->feeType->id }}"  name="fee_type_id[]"
                                                                    value="{{ $fee->feeType->id }}"
                                                                    data-month="{{ $month }}"
                                                                    data-amount="{{ $fee->amount }}" >
                                                                <input type="hidden" name="amount[{{ $uniqueKey }}]" value="{{ $fee->amount }}">
                                                                <input type="hidden" name="month[{{ $uniqueKey }}]" value="{{ $month }}">
                                                            </div>
                                                        @endforeach
                                                    </td>
                                                    <td class="text-center">Due</td>
                                                    <td>{{ $totalMonthAmount }}</td>
                                                </tr>
                                            @endforeach --}}
                                        @endif
                                        </tbody>
                                    </table>
                                </div>
                            @endisset
                        </div>
                        <div class="col-md-4">
                            <div class="fee__sum">
                                <div class="total__fees fs__l d-flex">
                                    <label>Total Fees:</label>
                                    <div class="value">
                                        <input type="text"
                                               class="form-control form-control-sm"
                                               name="total_amount"
                                               value="{{ $totalDue ?? '' }}" readonly>
                                    </div>
                                </div>
                                <div class="total__dis fs__l d-flex">
                                    <label>Total Discount:</label>
                                    <div class="value">
                                        <input type="text" class="form-control form-control-sm total_discount"
                                               name="total_discount"
                                               value="" readonly>
                                    </div>
                                </div>

                                <div class="late__fine fs__l d-flex justify-content-between">
                                    <div class="label__fine">
                                        <label>Late Fine:</label>
                                        <div class="custom-control custom-switch custom-switch-inline">
                                            <input type="checkbox" class="custom-control-input customSwitch1"
                                                   id="customSwitch1">
                                            <label class="custom-control-label" for="customSwitch1"></label>
                                        </div>
                                    </div>
                                    <div class="value">
                                        <input type="text" class="form-control form-control-sm late_fine"
                                               name="late_fine"
                                               value="" readonly>
                                    </div>
                                </div>
                                <div class="grand__total fs__l d-flex">
                                    <label>Grand Total:</label>
                                    <div class="value">
                                        <input type="text" class="form-control form-control-sm grand_total"
                                               name="grand_total"
                                               value="{{ $totalDue ?? '' }}" readonly>
                                    </div>
                                </div>
                                <div class="note my-3">
                                    <label class="mb-1">Payment Method:</label>
                                    {{ generateDropdown($paymentMethods, 'name="payment_method" id="payment_method" class="form-control form-control-sm" required', old('payment_method', Accounting::CASH), '' ) }}
                                </div>
                                <div class="note">
                                    <label class="mb-1">Note (Optional):</label>
                                    <textarea class="form-control form-control-sm note" name="note" id="" cols="30"
                                              rows="2"
                                              placeholder="Write note or description if needed."></textarea>
                                </div>

                            </div>
                            <div class="flex justify-content-end mt-3">
                                {{-- <button type="submit" class="btn btn-primary mt-2" name="action" value="collect">Collect</button> --}}
                                <button type="submit" class="btn btn-submit mt-2" name="action" value="collect-print">
                                    Submit & Print
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    @endif
@endsection

@section('scripts')


    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const monthCheckboxes = document.querySelectorAll('.month-checkbox');
            const feeCheckboxes = document.querySelectorAll('.fee-checkbox');
            const totalAmountInput = document.querySelector('.total_amount');
            const grandTotalInput = document.querySelector('.grand_total');

            function updateTotals() {
                let total = 0;

                document.querySelectorAll('.fee-checkbox:checked').forEach(cb => {
                    total += parseFloat(cb.dataset.amount);
                });

                totalAmountInput.value = total.toFixed(2);
                grandTotalInput.value = total.toFixed(2); // Assuming late fine is 0
            }

            monthCheckboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function () {
                    const month = this.dataset.month;

                    document.querySelectorAll(`.fee-checkbox[data-month="${month}"]`).forEach(cb => {
                        cb.checked = this.checked;
                    });

                    updateTotals();
                });
            });

            // Recalculate on manual fee-type checkbox changes too
            feeCheckboxes.forEach(cb => {
                cb.addEventListener('change', updateTotals);
            });

            // Optional: recalculate on page load (if some already checked)
            updateTotals();
        });
    </script>



    <script>
        $(document).ready(function () {
            // Select All checkbox change event
            $('#selectAll').change(function () {
                $('.feeTypeCheckbox').prop('checked', this.checked);
            });

            $('#multiselect').multiselect({
                // Customization Options
                enableFiltering: true,           // Search/Filter option
                filterPlaceholder: 'Search...',  // Filter placeholder text
                maxHeight: 250,                  // Maximum dropdown height
                numberDisplayed: 3,              // Number of selected items to display
                disableIfEmpty: true,            // Disable if no options
                includeSelectAllOption: true,
                // Text Configurations
                nonSelectedText: 'Select Options',
                allSelectedText: 'All Selected',

                // Button Width
                buttonWidth: '100%',

                // Custom Styling
                buttonClass: 'btn btn-light',

                // Event Handlers
                onChange: function (option, checked) {
                    var selectedOptions = $('#multiselect').val();
                }
            });

            const currentMonth = parseInt("{{ date('m') }}");
            const lateFineAmount = parseFloat("{{ get_setting_value(Settings::LATE_FINE_AMOUNT) }}");
            const lastPayDay = parseFloat("{{ get_setting_value(Settings::LATE_FINE_START_DAY) }}");
            const currentDay = parseInt("{{ date('d') }}");

            let totalAmount = 0;
            let totalDiscount = 0;
            let grandTotal = 0;
            let lateFine = 0;

            // Function to determine if late fine should apply
            function shouldApplyLateFine() {
                let applyLateFine = false;
                $('.feeTypeCheckbox:checked').each(function () {
                    const month = parseInt($(this).closest('tr').find('.fee-month').val());
                    if (month < currentMonth || (month === currentMonth && lastPayDay < currentDay)) {
                        applyLateFine = true;
                    }
                });
                return applyLateFine;
            }

            // Update totals
            function updateTotals(amountChange, discountChange) {
                totalAmount += amountChange;
                totalDiscount += discountChange;
                grandTotal = (totalAmount + lateFine) - totalDiscount;
                $('.total_amount').val(totalAmount);
                $('.total_discount').val(totalDiscount);
                $('.late_fine').val(lateFine);
                $('.grand_total').val(grandTotal);
            }

            // Individual checkbox change event
            $('.feeTypeCheckbox').change(function () {
                const amount = parseFloat($(this).closest('tr').find('.amountInput').val());
                const discount = parseFloat($(this).closest('tr').find('.discount').val() || 0);

                if (this.checked) {
                    updateTotals(amount, discount);
                } else {
                    updateTotals(-amount, -discount);
                }

                lateFine = shouldApplyLateFine() && $('.customSwitch1').prop('checked') ? lateFineAmount : 0;
                updateTotals(0, 0); // Update grand total with late fine
            });

            $('.customSwitch1').change(function () {
                lateFine = this.checked && shouldApplyLateFine() ? lateFineAmount : 0;
                $('.late_fine').val(lateFine);
                grandTotal = (totalAmount + lateFine) - totalDiscount;
                $('.grand_total').val(grandTotal);
            });
        });
    </script>
@endsection














@extends('layouts.master')

@section('content')
    <style>
        .custom-switch-inline {
            display: inline-block;
            margin-left: 10px; /* add some space between the label and the checkbox */
        }

        .custom-switch-inline .custom-control-label {
            margin-left: 5px; /* add some space between the checkbox and the label */
        }

        .table td, .table th {
            padding: .25rem;
            vertical-align: top;
            border-top: 1px solid #e3e6f0;
        }

        .select2-selection__rendered {
            line-height: 27px !important;
        }

        .data__search .content {
            border-left: 3px solid #ff8d00;
            padding-left: 7px;
        }

        .form-control:disabled, .form-control[readonly] {
            background-color: transparent;
            opacity: 1;
            border: none;
            color: #646464;
            font-weight: 300;
            padding-left: 0;
        }
        .fee__sum .form-control:disabled, .fee__sum .form-control[readonly] {
            background-color: transparent;
            opacity: 1;
            border: none;
            color: #000;
            font-weight: 700;
            padding-left: 0;
        }

        .fee__sum {
            background: #fffcf9;
            border: 1px solid orange;
            padding: 9px;
        }

        .fee__sum label {
            margin-bottom: 0;
            color: #222222;
        }

        .fee__sum .fs__l {
            background: #f397003b;
            line-height: 1;
            padding: 4px 7px;
            margin-bottom: 10px;
            justify-content: space-between;
            align-items: center;
        }
        /*.data__search .table-bordered td, .data__search .table-bordered th {*/
        /*    border: 1px solid #fce5bf;*/
        /*}*/
        .data__search .card-body .table .thead-light th {
            color: #000;
            background-color: #fce5bf;
            border-color: #fce5bf;
            font-weight: 400;
        }
    </style>

    <div class="card data__search">
        <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
            <h5>Collect Fees</h5>
            <a href="{{route('collect_fee.index')}}" class="btn btn-sm btn-primary">Collected Fees</a>
        </div>
        <div class="card-body">
            <form action="{{ route('collect_fee.create') }}" method="GET">
                {{-- @csrf --}}
                <div class="row">
                    <div class="col-md-12 col-lg-10">
                        <div class="row">
                            <div class="col-lg-3">
                                <div class="form-group mb-0">
                                    @component('components.search_student', [
                                        'student_name' => $student_name ?? '',
                                        'student_id_no' => $student_id_no ?? '',
                                        'required' => 'required',
                                    ])
                                    @endcomponent
                                </div>
                            </div>

                            <div class="col-lg-3">
                                <div class="form-group mb-0">
                                    {{ generateDropdown($years, 'name="year_id" class="form-control" required', old('year_id', $defaultYear), 'Year' ) }}
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="form-group mb-0">
                                    {{ multiSelectDropdown($months, 'name="month[]" class="form-control select2" required', old('month',request()->month ?? []), 'Select months...' ) }}
                                </div>
                            </div>
                            <div class="col-lg-2">
                                <button class="btn btn-info">Search</button>
                            </div>
                        </div>
                    </div>
                    @isset($student_details)

                        <div class="col-md-12">
                            <div class="content mt-3">
                                <div class="title">
                                    Student Info:
                                </div>
                                <div class="body d-flex">
                                    <div class="name mr-3">
                                        <span><b>Name:</b> {{ ($student_details->first_name ?? '') . ' ' . ($student_details->last_name ?? '') }}</span>
                                    </div>
                                    <div class="class mr-3">
                                        <span><b>Class (Section): </b>
                                            {{ $student_details->studentClass->class_name ?? '' }}
                                            @if ($student_details?->section?->section_name)
                                                ({{ $student_details?->section?->section_name }})
                                            @endif
                                        </span>
                                    </div>
                                    <div class="roll mr-3">
                                        <span><b>Roll: </b> {{ $student_details->class_roll ?? '' }}</span>
                                    </div>
                                    <div class="view">
                                        <a href="#modal"><i class="fa fa-eye"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endisset
                </div>
            </form>
        </div>
    </div>
    @if ($errors->any())
        <div class="alert alert-warning m-3" role="alert">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (isset($selectedFeeTypes) && empty($selectedFeeTypes))
        <div class="alert alert-warning m-3" role="alert">
            <h4>No Fees is setup yet for class "{{$student_details->studentClass->class_name}}"- {{$years[$year_id]}}. Please setup fees from <a href="{{route('class_fees.create')}}" target="_blank">here</a>.</h4>
        </div>
    @endif

    <div class="card mt-2 data__search">
        <div class="card-body">
            @if (isset($selectedFeeTypes) && !empty($selectedFeeTypes))
                <form action="{{ route('collect_fee.store') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-8">
                            @isset($student_details)
                                <input type="hidden" name="student_id" value="{{ $student_details->id }}">
                                <input type="hidden" name="discount_type" value="{{ $discount?->discount_type }}">
                                <input type="hidden" name="discount" value="{{ $discount?->amount }}">
                                <input type="hidden" name="year_id" value="{{ $year_id ?? '' }}">
                                <input type="hidden" name="shift_id" value="{{ $student_details->shift_id }}">
                                <input type="hidden" name="student_class_id" value="{{ $student_details->student_class_id }}">
                                <input type="hidden" name="section_id" value="{{ $student_details->section_id }}">
                                <div class="table-responsive">
                                    <table class="table table-bordered" id="feeTypeTable">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Select
                                                </th>
                                                <th>Fee Category</th>
                                                <th>Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $total_amount = 0;
                                            @endphp

                                            @if (!empty($selectedFeeTypes))
                                                @foreach ($feeTypes as $feeType)
                                                    @php
                                                        $amount = calculateFeeAmount($feeType, $selectedFeeTypes, $transport_fee, $hostel_fee);
                                                        $single_discount = calculateStudentDiscount($amount, $discount);
                                                        $total_amount += $amount;
                                                    @endphp

                                                    @if (($feeType->code == "TRANSPORT" || $feeType->code == "HOSTEL" || $feeType->code == "TUITION") && !empty($selectedMonth) && in_array($feeType->month, $selectedMonth))
                                                        @if ($amount > 0)
                                                            <tr>
                                                                <td>
                                                                    @if (!empty($invoice_fee_type_id) && in_array($feeType->id, $invoice_fee_type_id))
                                                                        <div class="custom-control custom-checkbox">
                                                                            <input type="checkbox" class="custom-control-input" id="customCheckDisabled1" disabled="">
                                                                            <label class="custom-control-label" for="customCheckDisabled1">
                                                                                <span class="badge badge-success">Paid</span>
                                                                            </label>
                                                                        </div>
                                                                    @else
                                                                        <div class="custom-control custom-checkbox">
                                                                            <input type="checkbox" class="custom-control-input feeTypeCheckbox" value="{{ $feeType->id }}" id="customCheck{{ $feeType->id }}" name="fee_type_id[]">
                                                                            <label class="custom-control-label text-danger" for="customCheck{{ $feeType->id }}">
                                                                                <span class="badge badge-danger">Due</span>
                                                                            </label>
                                                                        </div>
                                                                    @endif
                                                                </td>
                                                                <td>{{ $feeType->title . ' (' . $years[$year_id] .')'}}</td>
                                                                <td>
                                                                    <input type="number" name="amount[{{ $feeType->id }}]" class="form-control form-control-sm amountInput" value="{{ $amount }}" placeholder="Enter amount" readonly>
                                                                    <input type="hidden" class="discount" value="{{ $single_discount }}">
                                                                    <input type="hidden" class="fee-month" name="fee_month" value="{{$feeType->month}}">
                                                                    <input type="hidden" name="month[{{ $feeType->id }}]" value="{{ $feeType->month }}">
                                                                </td>
                                                            </tr>
                                                        @endif
                                                    @elseif (array_key_exists($feeType->id, $selectedFeeTypes) && !empty($feeType->month) && in_array($feeType->month, $selectedMonth))
                                                        <tr>
                                                            <td>
                                                                @if (!empty($invoice_fee_type_id) && in_array($feeType->id, $invoice_fee_type_id))
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input" id="customCheckDisabled1" disabled="">
                                                                        <label class="custom-control-label" for="customCheckDisabled1">
                                                                            <span class="badge badge-success">Paid</span>
                                                                        </label>
                                                                    </div>
                                                                @else
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input feeTypeCheckbox" value="{{ $feeType->id }}" id="customCheck{{ $feeType->id }}" name="fee_type_id[]">
                                                                        <label class="custom-control-label" for="customCheck{{ $feeType->id }}">
                                                                            <span class="badge badge-danger">Due</span>
                                                                        </label>
                                                                    </div>
                                                                @endif
                                                            </td>
                                                            <td>{{ $feeType->title . ' (' . $years[$year_id] }})</td>
                                                            <td>
                                                                <input type="number" name="amount[{{ $feeType->id }}]" class="form-control form-control-sm amountInput" value="{{ $amount }}" placeholder="Enter amount" readonly>
                                                                <input type="hidden" class="discount" value="{{ $single_discount }}">
                                                                <input type="hidden" class="fee-month" name="fee_month" value="{{$feeType->month}}">
                                                                <input type="hidden" name="month[{{ $feeType->id }}]" value="{{ $feeType->month }}">
                                                            </td>
                                                        </tr>
                                                    @elseif (array_key_exists($feeType->id, $selectedFeeTypes) && empty($feeType->month))
                                                        <tr>
                                                            <td>
                                                                @if (!empty($invoice_fee_type_id) && in_array($feeType->id, $invoice_fee_type_id))
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input" id="customCheckDisabled1" disabled="">
                                                                        <label class="custom-control-label" for="customCheckDisabled1">
                                                                            <span class="badge badge-success">Paid</span>
                                                                        </label>
                                                                    </div>
                                                                @else
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input feeTypeCheckbox"
                                                                            value="{{ $feeType->id }}" id="customCheck{{ $feeType->id }}"
                                                                            name="fee_type_id[]">
                                                                        <label class="custom-control-label text-danger"
                                                                            for="customCheck{{ $feeType->id }}">
                                                                            <span class="badge badge-danger">Due</span>
                                                                        </label>
                                                                    </div>
                                                                @endif
                                                            </td>
                                                            <td>{{ $feeType->title.' ('.$years[$year_id] }})</td>
                                                            <td>
                                                                <input type="number" name="amount[{{ $feeType->id }}]"
                                                                    class="form-control form-control-sm amountInput" value="{{ $amount }}"
                                                                    placeholder="Enter amount" readonly>
                                                                <input type="hidden" class="discount" value="{{ $single_discount ?? 0 }}">
                                                                <input type="hidden" class="fee-month" name="fee_month" value="{{$feeType->month}}">
                                                                <input type="hidden" name="month[{{ $feeType->id }}]" value="">
                                                            </td>
                                                        </tr>
                                                    @endif
                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            @endisset
                        </div>
                        <div class="col-md-4">
                            <div class="fee__sum">
                                <div class="total__fees fs__l d-flex">
                                    <label>Total Fees:</label>
                                    <div class="value">
                                        <input type="text"
                                            class="form-control form-control-sm total_amount"
                                            name="total_amount"
                                            value="" readonly>
                                    </div>
                                </div>
                                <div class="total__dis fs__l d-flex">
                                    <label>Total Discount:</label>
                                    <div class="value">
                                        <input type="text" class="form-control form-control-sm total_discount"
                                            name="total_discount"
                                            value="" readonly>
                                    </div>
                                </div>

                                <div class="late__fine fs__l d-flex">
                                    <div class="label__fine">
                                        <label>Late Fine:</label>
                                        <div class="custom-control custom-switch custom-switch-inline">
                                            <input type="checkbox" class="custom-control-input customSwitch1"
                                                id="customSwitch1">
                                            <label class="custom-control-label" for="customSwitch1"></label>
                                        </div>
                                    </div>
                                    <div class="value">
                                        <input type="text" class="form-control form-control-sm late_fine" name="late_fine"
                                            value="" readonly>
                                    </div>
                                </div>
                                <div class="grand__total fs__l d-flex">
                                    <label>Grand Total:</label>
                                    <div class="value">
                                        <input type="text" class="form-control form-control-sm grand_total"
                                            name="grand_total"
                                            value="" readonly>
                                    </div>
                                </div>
                                <div class="note">
                                    <label class="mb-2">Payment Method:</label>
                                    {{ generateDropdown($paymentMethods, 'name="payment_method" id="payment_method" class="form-control" required', old('payment_method', Accounting::CASH), '' ) }}
                                </div>
                                <div class="note">
                                    <label class="mb-2">Note (Optional):</label>
                                    <textarea class="form-control form-control-sm note" name="note" id="" cols="30"
                                            rows="2"
                                            placeholder="Write note or description if needed."></textarea>
                                </div>

                            </div>
                            <div class="flex justify-content-end mt-3">
                                {{-- <button type="submit" class="btn btn-primary mt-2" name="action" value="collect">Collect</button> --}}
                                <button type="submit" class="btn btn-primary mt-2" name="action" value="collect-print">Collect & Print</button>
                            </div>
                        </div>
                    </div>
                </form>
            @else
                <div class="flex justify-content-center">
                    <h4>Search above with Student ID/Gurdian Mobile, year and month to collect fees.</h4>
                </div>
            @endif
        </div>
    </div>

@endsection

@section('scripts')
<script>
    $(document).ready(function () {
        // Select All checkbox change event
        $('#selectAll').change(function () {
            $('.feeTypeCheckbox').prop('checked', this.checked);
        });

        const currentMonth = parseInt("{{ date('m') }}");
        const lateFineAmount = parseFloat("{{ get_setting_value(Settings::LATE_FINE_AMOUNT) }}");
        const lastPayDay = parseFloat("{{ get_setting_value(Settings::LATE_FINE_START_DAY) }}");
        const currentDay = parseInt("{{ date('d') }}");

        let totalAmount = 0;
        let totalDiscount = 0;
        let grandTotal = 0;
        let lateFine = 0;

        // Function to determine if late fine should apply
        function shouldApplyLateFine() {
            let applyLateFine = false;
            $('.feeTypeCheckbox:checked').each(function () {
                const month = parseInt($(this).closest('tr').find('.fee-month').val());
                if (month < currentMonth || (month === currentMonth && lastPayDay < currentDay)) {
                    applyLateFine = true;
                }
            });
            return applyLateFine;
        }

        // Update totals
        function updateTotals(amountChange, discountChange) {
            totalAmount += amountChange;
            totalDiscount += discountChange;
            grandTotal = (totalAmount + lateFine) - totalDiscount;
            $('.total_amount').val(totalAmount);
            $('.total_discount').val(totalDiscount);
            $('.late_fine').val(lateFine);
            $('.grand_total').val(grandTotal);
        }

        // Individual checkbox change event
        $('.feeTypeCheckbox').change(function () {
            const amount = parseFloat($(this).closest('tr').find('.amountInput').val());
            const discount = parseFloat($(this).closest('tr').find('.discount').val() || 0);

            if (this.checked) {
                updateTotals(amount, discount);
            } else {
                updateTotals(-amount, -discount);
            }

            lateFine = shouldApplyLateFine() && $('.customSwitch1').prop('checked') ? lateFineAmount : 0;
            updateTotals(0, 0); // Update grand total with late fine
        });

        $('.customSwitch1').change(function () {
            lateFine = this.checked && shouldApplyLateFine() ? lateFineAmount : 0;
            $('.late_fine').val(lateFine);
            grandTotal = (totalAmount + lateFine) - totalDiscount;
            $('.grand_total').val(grandTotal);
        });
    });
</script>
@endsection
