<!-- resources/views/class_fees/create.blade.php -->
@extends('layouts.master')

@section('content')
    <style>
        .custom-switch-inline {
            display: inline-block;
            margin-left: 10px; /* add some space between the label and the checkbox */
        }

        .custom-switch-inline .custom-control-label {
            margin-left: 5px; /* add some space between the checkbox and the label */
        }
    </style>
    <div class="card">
        <div class="card-body">
            <form action="{{ route('collect_fee.search_fees') }}" method="POST">
                @csrf
                <div class="row">
                    <div class="form-group col-lg-3 col-md-4 col-sm-6">
                        @component('components.search_student', [
                            'student_name' => $student_name ?? '',
                            'student_id_no' => $student_id_no ?? '',
                            'required' => 'required',
                        ])
                        @endcomponent
                    </div>
                    <div class="col-lg-3 col-md-4 col-sm-6">
                        <div class="form-group">
                            {{ generateDropdown($years, 'name="year_id" id="year_id" class="form-control" required', $year_id ) }}
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6">
                        <div class="form-group">
                            <select name="month[]" class="form-control select2" multiple data-placeholder="Select months...">
                                @foreach ($months as $key=>$month)
                                    @if (in_array($key, $selectedMonth))
                                        <option value="{{$key}}" selected>{{$month}}</option>
                                    @else
                                        <option value="{{$key}}">{{$month}}</option>
                                    @endif

                                @endforeach
                            </select>

                        </div>
                    </div>
                    <div class="col-lg-2 col-md-2 col-sm-2">
                        <button class="btn btn-info">Search</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    @if (isset($selectedFeeTypes) && empty($selectedFeeTypes))
        <div class="alert alert-warning m-3" role="alert">
            <h4>No Fees is setup yet for class "{{$student_details->studentClass->class_name}}"- {{$years[$year_id]}}. Please setup fees from <a href="{{route('class_fees.create')}}" target="_blank">here</a>.</h4>
        </div>
    @endif

    <div class="card mt-2">
        <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
            <h5>Collect Fees</h5>
            <a href="{{ route('collect_fee.index') }}" class="btn btn-sm btn-primary">Collected Fees</a>
        </div>
        <div class="card-body">
            @if (isset($selectedFeeTypes) && !empty($selectedFeeTypes))
                <form action="{{ route('collect_fee.store') }}" method="POST">
                    @csrf

                    <!--Student Details Start-->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            @isset($student_details)
                                <input type="hidden" name="student_id" value="{{ $student_details->id }}">
                                <input type="hidden" name="discount_type" value="{{ $discount?->discount_type }}">
                                <input type="hidden" name="discount" value="{{ $discount?->amount }}">
                                <input type="hidden" name="year_id" value="{{ $year_id ?? '' }}">

                                <table class="table border">
                                    <tbody>
                                        <tr>
                                            <th>Name</th>
                                            <td>: {{ ($student_details->first_name ?? '') . ' ' . ($student_details->last_name ?? '') }}
                                            </td>
                                            <th>Class (Section)</th>
                                            <td>: {{ $student_details->studentClass->class_name ?? '' }}
                                                @if ($student_details?->section?->section_name)
                                                    ({{ $student_details?->section?->section_name }})
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Student ID</th>
                                            <td>: {{ $student_id_no }}</td>
                                            <th>Roll Number</th>
                                            <td> : {{ $student_details->class_roll ?? '' }} </td>
                                        </tr>
                                        <tr>
                                            <th>Mobile Number</th>
                                            <td>: {{ $student_details?->mobile_no ?? '' }}</td>
                                            <th>Department</th>
                                            <td>: {{ $student_details?->departmentInfo?->name ?? '' }} </td>
                                        </tr>
                                    </tbody>
                                </table>
                            @endisset
                        </div>
                    </div>
                    <!--Student Details End-->

                    <!--Student Fee Details Start-->
                    <div class="table-responsive">
                        <table class="table table-bordered" id="feeTypeTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>Select
                                        {{-- <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" id="selectAll">
                                            <label class="custom-control-label" for="selectAll">Select All</label>
                                        </div> --}}
                                    </th>
                                    <th>Fee Category</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $total_amount = 0;
                                    // $total_discount = 0;
                                @endphp

                                @if (!empty($selectedFeeTypes))
                                    @foreach ($feeTypes as $feeType)
                                        @php
                                            $amount = calculateFeeAmount($feeType, $selectedFeeTypes, $transport_fee, $hostel_fee);
                                            $single_discount = calculateStudentDiscount($amount, $discount);
                                            $total_amount += $amount;
                                        @endphp

                                        @if (($feeType->code == "TRANSPORT" || $feeType->code == "HOSTEL" || $feeType->code == "TUITION") && !empty($selectedMonth) && in_array($feeType->month, $selectedMonth))
                                            @if ($amount > 0)
                                                <tr>
                                                    <td>
                                                        @if (!empty($invoice_fee_type_id) && in_array($feeType->id, $invoice_fee_type_id))
                                                            <div class="custom-control custom-checkbox">
                                                                <input type="checkbox" class="custom-control-input" id="customCheckDisabled1" disabled="">
                                                                <label class="custom-control-label" for="customCheckDisabled1">Paid</label>
                                                            </div>
                                                        @else
                                                            <div class="custom-control custom-checkbox">
                                                                <input type="checkbox" class="custom-control-input feeTypeCheckbox" value="{{ $feeType->id }}" id="customCheck{{ $feeType->id }}" name="fee_type_id[]">
                                                                <label class="custom-control-label" for="customCheck{{ $feeType->id }}">Not Paid</label>
                                                            </div>
                                                        @endif
                                                    </td>
                                                    <td>{{ $feeType->title . ' (' . $years[$year_id] }})</td>
                                                    <td>
                                                        <input type="number" name="amount[{{ $feeType->id }}]" class="form-control form-control-sm amountInput" value="{{ $amount }}" placeholder="Enter amount" readonly>
                                                        <input type="hidden" class="discount" value="{{ $single_discount }}">
                                                    </td>
                                                </tr>
                                            @endif
                                        @elseif (array_key_exists($feeType->id, $selectedFeeTypes) && !empty($feeType->month) && in_array($feeType->month, $selectedMonth))
                                            <tr>
                                                <td>
                                                    @if (!empty($invoice_fee_type_id) && in_array($feeType->id, $invoice_fee_type_id))
                                                        <div class="custom-control custom-checkbox">
                                                            <input type="checkbox" class="custom-control-input" id="customCheckDisabled1" disabled="">
                                                            <label class="custom-control-label" for="customCheckDisabled1">Paid</label>
                                                        </div>
                                                    @else
                                                        <div class="custom-control custom-checkbox">
                                                            <input type="checkbox" class="custom-control-input feeTypeCheckbox" value="{{ $feeType->id }}" id="customCheck{{ $feeType->id }}" name="fee_type_id[]">
                                                            <label class="custom-control-label" for="customCheck{{ $feeType->id }}">Not Paid</label>
                                                        </div>
                                                    @endif
                                                </td>
                                                <td>{{ $feeType->title . ' (' . $years[$year_id] }})</td>
                                                <td>
                                                    <input type="number" name="amount[{{ $feeType->id }}]" class="form-control form-control-sm amountInput" value="{{ $amount }}" placeholder="Enter amount" readonly>
                                                    <input type="hidden" class="discount" value="{{ $single_discount }}">
                                                </td>
                                            </tr>
                                        @elseif (array_key_exists($feeType->id, $selectedFeeTypes) && empty($feeType->month))
                                            <tr>
                                                <td>
                                                    @if (!empty($invoice_fee_type_id) && in_array($feeType->id, $invoice_fee_type_id))
                                                        <div class="custom-control custom-checkbox">
                                                            <input type="checkbox" class="custom-control-input"
                                                                id="customCheckDisabled1" disabled="">
                                                            <label class="custom-control-label"
                                                                for="customCheckDisabled1">Paid</label>
                                                        </div>
                                                    @else
                                                        <div class="custom-control custom-checkbox">
                                                            <input type="checkbox" class="custom-control-input feeTypeCheckbox"
                                                                value="{{ $feeType->id }}" id="customCheck{{ $feeType->id }}"
                                                                name="fee_type_id[]">
                                                            <label class="custom-control-label"
                                                                for="customCheck{{ $feeType->id }}">Not Paid</label>
                                                        </div>
                                                    @endif
                                                </td>
                                                <td>{{ $feeType->title.' ('.$years[$year_id] }})</td>
                                                <td>

                                                    <input type="number" name="amount[{{ $feeType->id }}]"
                                                        class="form-control form-control-sm amountInput" value="{{ $amount }}"
                                                        placeholder="Enter amount" readonly>
                                                    <input type="hidden" class="discount" value="{{ $single_discount ?? 0 }}">
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                @endif
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="2">Total Fees</td>
                                    <td>
                                        <input type="text" class="form-control form-control-sm total_amount" name="total_amount"
                                            value="" readonly>

                                    </td>
                                </tr>
                                <tr>
                                    {{-- @php
                                        if (!empty($discount)) {
                                            if ($discount->discount_type == 'percentage' && $discount->amount > 0) {
                                                $total_discount = ($total_amount * $discount->amount) / 100;
                                            } elseif ($discount->discount_type == 'fixedamount' && $discount->amount > 0) {
                                                $total_discount = $discount->amount;
                                            }
                                        }
                                    @endphp --}}
                                    <td colspan="2">Total Discount</td>
                                    <td>
                                        <input type="text" class="form-control form-control-sm total_discount" name="total_discount"
                                            value="" readonly>

                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <label class="mr-5">Late Fine</label>
                                        <div class="custom-control custom-switch custom-switch-inline">
                                            <input type="checkbox" class="custom-control-input customSwitch1" id="customSwitch1">
                                            <label class="custom-control-label" for="customSwitch1">Skip</label>
                                        </div>
                                    </td>
                                    <td>
                                        @php
                                            $last_pay_day = '10';
                                            $today = date('d');
                                            $fine_amount = 0;
                                            if ($last_pay_day < $today && !empty($selectedFeeTypes)) {
                                                $fine_amount = 10;
                                            }
                                        @endphp
                                        <input type="text" class="form-control form-control-sm late_fine" name="late_fine" value=""
                                            readonly>
                                        <input type="hidden" class="hidden_late_fine" value="{{ $fine_amount }}" readonly>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">Grand Total</td>
                                    <td>
                                        <input type="text" class="form-control form-control-sm grand_total" name="grand_total"
                                            value="" readonly>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="1">Note (Optional)</td>
                                    <td colspan="2">
                                        <textarea class="form-control form-control-sm note" name="note" id="" cols="30" rows="2"
                                            placeholder="Write note or description if needed."></textarea>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!--Student Fee Details End-->

                    @if (isset($selectedFeeTypes) && !empty($selectedFeeTypes))
                        <div class="flex justify-content-end">
                            <button type="submit" name="collect" class="btn btn-primary mt-2">Collect</button>
                            <button type="submit" name="collect-print" class="btn btn-primary mt-2">Collect & Print</button>
                        </div>
                    @endif
                </form>
            @else
                <div class="flex justify-content-center">
                    <h4>Search above with Student ID/Gurdian Mobile, year and month to collect fees.</h4>
                </div>
            @endif
        </div>
    </div>

@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            // Select All checkbox change event
            $('#selectAll').change(function() {
                if (this.checked) {
                    // Check all checkboxes in the table body
                    $('.feeTypeCheckbox').prop('checked', true);
                } else {
                    // Uncheck all checkboxes in the table body
                    $('.feeTypeCheckbox').prop('checked', false);
                }

            });
            let total_amount = 0;
            let total_discount = 0;
            let grand_total = 0;
            let late_fine = 0;
            // Individual checkbox change event
            $('.feeTypeCheckbox').change(function() {

                let amount = $(this).closest('tr').find('.amountInput').val();
                let discount = $(this).closest('tr').find('.discount').val() ?? 0;

                late_fine = parseFloat($('.hidden_late_fine').val());
                if (this.checked) {
                    total_amount += parseFloat(amount);
                    total_discount += parseFloat(discount);
                } else {
                    total_amount -= parseFloat(amount);
                    total_discount -= parseFloat(discount);
                }
                grand_total = (total_amount + late_fine) - total_discount;
                $('.total_amount').val(total_amount)
                $('.total_discount').val(total_discount)
                $('.late_fine').val(late_fine)
                $('.grand_total').val(grand_total)
            });

            $('.customSwitch1').change(function() {
                if (this.checked) {
                    $('.late_fine').val('')
                    grand_total -= late_fine
                    $('.grand_total').val(grand_total)
                } else {
                    $('.late_fine').val(late_fine)
                    grand_total += late_fine
                    $('.grand_total').val(grand_total)
                }
            });

        });
    </script>
@endsection
