@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-body card__head">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs">
            <li class="nav-item">
                <a class="nav-link {{ request()->query('tab', 'search') === 'search' ? 'active' : '' }}" data-toggle="tab" href="#search-tab">Search By ID</a>
            </li>
            <li class="nav-item">
                <a class="nav-link {{ request()->query('tab') === 'filter' ? 'active' : '' }}" data-toggle="tab" href="#filter-tab">Search by Class</a>
            </li>
        </ul>
        <!-- Tab panes -->
        <div class="tab-content">
            <div id="search-tab" class="tab-pane {{ request()->query('tab', 'search') === 'search' ? 'show active' : '' }}"><br>
                <form method="GET" action="{{ route('collect_fee.due-list') }}" class="row">
                    <input type="hidden" name="tab" value="search">
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        @component('components.search_student', [
                            'student_name' => $student_name ?? '',
                            'student_id_no' => request()->student_id_no ?? '',
                            'required' => '',
                        ])
                        @endcomponent
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </form>
            </div>
            <div id="filter-tab" class="tab-pane fade {{ request()->query('tab') === 'filter' ? 'show active' : '' }}"><br>
                <form method="GET" action="{{ route('collect_fee.due-list') }}" class="row">
                    <input type="hidden" name="tab" value="filter">
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown($classes, 'class="form-control student_class select2" id="student_class" name="student_class"', request()->query('student_class'), "Class") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown([], 'class="form-control form-control-sm section" id="section" name="section"', request()->query('section'), "Section") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown($years, 'class="form-control select2 academic_year" id="academic_year" name="academic_year" required', request()->query('academic_year') ?? $defaultYear, "Year") }}         
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown($months, 'class="form-control form-control-sm month" id="month" name="month"', request()->query('month', now()->format('n')) , "Month") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    </div>
    <div class="card mt-4">
        <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
            <h6>Due Fees</h6>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table" id="dataTable">
                        <thead class="thead-light">
                            <tr>
                                <th>SN</th>
                                <th>Student ID</th>
                                <th>Name</th>
                                <th>Class</th>
                                <th>Month</th>
                                <th>Total Amount</th>
                                <th class="text-center">Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if($dueFees->count() > 0)
                                @php
                                $sn = 1;
                                @endphp
                                @forelse ($dueFees as $payment)
                                    @if ($payment->total_amount !== $payment->paid_amount)
                                        <tr>
                                            <td>{{ $sn++ }}</td>
                                            <td>{{ $payment->student_id_no }}</td>
                                            <td>{{ $payment->name }}</td>
                                            <td>{{ $payment->class_name }}</td>
                                            <td>{{ \Carbon\Carbon::create()->month($payment->month)->format('F') }} </td>
                                            
                                            <td>{{ $payment->total_amount }}</td>
                                            <td class="text-center">
                                                @if ($payment->total_amount == $payment->paid_amount)
                                                    <span class="badge badge-success">Paid</span>
                                                @else
                                                    <span class="badge badge-danger">Unpaid</span>
                                                @endif
                                            </td>
                                            <td>
                                            @php
                                                $months = getMonthsBasedOnCurrent(3,2);
                                            @endphp
                                            <a href="{{ route('collect_fee.create', ['student_id_no' => $payment->student_id_no, 'year_id' => $defaultYear, 'month' => $months]) }}" class="btn btn-sm btn-soft-success" target="_blank"><i class="fas fa-file-invoice-dollar"></i></a>
                                        </td>
                                        </tr>
                                    @endif
                                @empty
                                @endforelse
                            @else
                                <tr>
                                    <td colspan="8" class="text-center">No data found</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    @push('scripts')
        <script type="text/javascript">
            
            function formatCurrency(value) {
                if (value === null || value === '') {
                    return '0';
                }
                let roundedValue = Math.round(value);
                return roundedValue.toString();
            }
        </script>
    @endpush
@endsection
@push('scripts')
    <script>
        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });
        let student_class_id = "{{ request()->query('student_class') ?? '' }}";
        if(student_class_id!=''){
            getSection(student_class_id);
        }
        function getSection(student_class_id){
            let section_id = "{{ request()->query('section') ?? '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;
                    console.log(sections);
                    let option = '<option value="">Section</option>';
                    for(let i=0;i<sections.length;i++){
                        if(section_id==sections[i].id){
                            option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                        }else{
                            option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                        }
                    }
                    $('select.section').empty().append(option);
                });
            }
        }
    </script>
@endpush    