@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header py-3  card__head">
        <form action="{{ route('collect_fee.index') }}" method="GET">
            <div class="row">
                <div class="col-lg-3">
                    <div class="form-group mb-2">
                        @component('components.search_student', [
                            'student_name' => $student_name ?? '',
                            'student_id_no' => request()->student_id_no ?? '',
                            'required' => '',
                        ])
                        @endcomponent
                    </div>
                </div>

                <div class="col-lg-3">
                    <div class="form-group mb-2">
                        {{ generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class"', request()->query('student_class'), "Select Class") }}
                    </div>
                </div>

                <div class="col-lg-3">
                    <div class="form-group mb-2">
                        {{ generateDropdown([], 'class="form-control form-control-sm section" id="section" name="section"', request()->query('section'), "Section") }}
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="form-group mb-2">
                    <button class="btn btn-info">Search</button>
                </div>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Fee Invoices</h6>
            @can('accounting.collect-fees.create')
                <a href="{{ route('collect_fee.create') }}" class="btn btn-sm btn-light-blue">Add New</a>
            @endcan
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive">
                <table class="table" id="dataTable">
                    <thead class="thead-light">
                        <tr>
                            <th>Std. ID</th>
                            <th>Name</th>
                            <th>Class</th>
                            <th>Invoice No</th>
                            <th>Total Amount</th>
                            <th>Total Discount</th>
                            <th>Late Fine</th>
                            <th>Payable Amount</th>
                            <th>Status</th>
                            <th>Payment Method</th>
                            <th>Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @php
                            $sn = 0;
                        @endphp

                        @if ($collectedFees)

                        @endif
                        @foreach ($collectedFees as $fee)
                            <tr>
                                <td>{{$fee->student->student_id_no }}</td>
                                <td>{{$fee->student->first_name.' '.$fee->student->last_name}}</td>
                                <td>{{$fee->student->studentClass->class_name}}</td>
                                <td>{{$fee->invoice_no}}</td>
                                <td>{{$fee->total_amount}}</td>
                                <td>{{$fee->total_discount}}</td>
                                <td>{{$fee->late_fine}}</td>
                                <td>{{($fee->total_amount-$fee->total_discount)+$fee->late_fine}}</td>
                                <td>{!!getStatusBadge($fee->status)!!}</td>
                                <td>{{$fee->payment_method}}</td>
                                <td>{{$fee->invoice_date}}</td>
                                <td class="d-flex justify-content-start">
                                    @can('accounting.collect-fees.view')
                                        @if($fee->status != 'Due')
                                            <a href="{{ route('collect_fee.show', $fee->uuid) }}" class="btn btn-sm btn-soft-success mr-1" target="_blank"><i class="fas fa-eye"></i></a>
                                        @endif
                                    @endcan
                                    @can('accounting.collect-fees.edit')

                                    @endcan
                                    @can('accounting.collect-fees.delete')
                                        <form action="{{ route('collect_fee.destroy', $fee->id) }}"
                                            method="POST"
                                            onsubmit="return confirm('Are you sure you want to delete this')"
                                            style="display:inline-block;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                        </form>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
    <script>
        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ request()->query('student_class') ?? '' }}";

        if(student_class_id!=''){
            getSection(student_class_id);
        }

        function getSection(student_class_id){

            let section_id = "{{ request()->query('section') ?? '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;
                    console.log(sections);
                    let option = '<option value="">Select Section</option>';
                    for(let i=0;i<sections.length;i++){
                        if(section_id==sections[i].id){
                            option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                        }else{
                            option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                        }
                    }
                    $('select.section').empty().append(option);
                });
            }
        }
    </script>
@endpush

