@extends('layouts.master')
@section('content')
    <style>
        body {
            font-family: sans-serif;
        }

        p {
            margin-top: 0;
            margin-bottom: 10px;
        }

        .invoice_header .content h2 {
            margin-top: 0;
            margin-bottom: 12px;
            font-size: 21px;
            font-weight: 700;
        }

        .invoice_header .content p {
            margin-bottom: 5px;
            font-weight: 300;
            color: #5a5a5a;
            font-size: 15px;
        }

        .invoice_header {
            display: flex;
        }

        .invoice_header .img {
            width: 25%;
        }

        .invoice_header .img img {
            width: 200px;
            height: 124px;
        }

        .invoice_header .content {
            color: black;
            width: 75%;
        }

        .invoice_footer .title_message {
            text-align: center;
            margin-top: 0;
            font-family: cursive;
            color: black;
            margin-bottom: 7px;
            font-size: 13px;
        }

        .invoice_footer .powerby {
            color: #747474;
            font-size: 12px;
            font-weight: 300;
            text-align: center;
            background: #eee;
            margin-top: 12px;
            padding: 5px;
            line-height: 1;
        }

        .invoice_footer .powerby span {
            color: black;
            letter-spacing: .5px;
            font-weight: bold;
        }

        .invoice_content {
            width: 100%;
            max-width: 210mm;
            margin: 0px auto 2.5em;
            padding: 20px;
            border: 1px dotted #ccc;
            background-color: #fff;
        }

        .invoice_body {
            padding: 20px;
        }

        .invoice_body .head {
            padding: 15px;
            border: 1px solid #ededed;
            display: flex;
            margin-bottom: 8px;
            background-color: #f5f5f5b8;
        }

        .invoice_body .head .left {
            width: 50%;
            text-align: left;
            color: black;
        }

        .invoice_body .head .right p,
        .invoice_body .head .left p {
            margin-bottom: 7px;
            margin-top: 0;
            font-size: 15px;
        }

        .invoice_body .head .right {
            width: 50%;
            text-align: right;
            color: black;
        }

        .invoice_body .head .right span {
            font-weight: 700;
            font-size: 28px;
            color: #000;
        }

        .invoice_body .body table thead {
            background: #e1e1e1;
        }

        .invoice_body .body table thead th:first-child {
            border-radius: 0 !important;
        }

        .invoice_body .body table thead th:nth-child(3),
        .invoice_body .body table tbody td:nth-child(3) {
            text-align: center;
        }

        .invoice_body .body table thead th:nth-child(4),
        .invoice_body .body table tbody td:nth-child(4) {
            text-align: right;
        }

        .invoice_body .body table thead th:last-child {
            border-radius: 0 !important;
            text-align: right;
        }

        .invoice_body .body table thead tr th {
            border: none;
            padding: 6px 10px;
            color: black;
            line-height: 1;
        }

        .invoice_body .body table {
            margin-bottom: 8px;
        }

        .invoice_body .body table tbody tr td {
            border-top: none;
            padding: 8px;
            color: black;
            border-bottom: 1px solid #e9e9e9;
        }

        .invoice_body .foot {
            display: flex;
        }

        .invoice_body .foot .prepared_by {
            width: 35%;
            text-align: center;
        }

        .invoice_body .foot .prepared_by .name {
            border-top: 1px solid;
            color: black;
        }

        .invoice_body .foot .content {
            width: 65%;
            text-align: right;
            color: black;
            padding-right: 10px;
        }

        .invoice_body .foot .content p {
            margin-bottom: 6px;
            font-size: 14px;
            color: #4a4a4a;
        }

        @media print {
            .invoice_content {
                margin: 0;
                border: none;
                background-color: #fff;
            }

            #invoice {
                padding: 20px;
            }

            @page {
                size: A5;
                margin: 0;
            }

            body {
                margin: 0;
            }
        }
    </style>
    @if (isset($invoice) && !empty($invoice))
        <div class="card p-1 invoice">
            <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
                <button class="btn btn-success btn-sm" onclick="closeWindow()">Back</button>
                <button class="btn btn-success btn-sm" onclick="printInv()">Print</button>
            </div>
            <div class="card-body mt-4 invoice_content">
                <div class="invoice_header">
                    <div class="img">
                        <img src="{{ asset('uploads/images/logo-white.jpg') }}" alt="Logo">
                    </div>
                    <div class="content">
                        @php
                            $get_branch_info = get_branch_info();
                        @endphp
                        <h2>{{get_setting_value(Settings::SCHOOL_NAME)}}</h2>
                        <p>{{$get_branch_info->address}}</p>
                        <p>Contact: {{$get_branch_info->contact_info}}</p>
                        <p>Email: {{get_setting_value(Settings::SCHOOL_EMAIL)}}</p>
                    </div>
                </div>
                <div class="invoice_body">
                    <div class="head">
                        <div class="left">
                            <p><b>Name: {{ $student_details->first_name ?? '' }} {{ $student_details->last_name ?? '' }}</b>
                            </p>
                            <p>Student ID: {{ $student_details->student_id_no ?? '' }}</p>
                            <p>Class: {{ $student_details->studentClass->class_name ?? '' }} {{ $student_details?->section?->section_name ? ' (' . $student_details?->section?->section_name . ')' : '' }} </p>
                            <p>Roll No: {{ $student_details->class_roll ?? '' }}</p>
                        </div>
                        <div class="right">
                            <p>Invoice: {{ $invoice->invoice_no ?? '' }} </p>
                            <p>Date: {{ date('d-m-Y', strtotime($invoice->invoice_date)) ?? '' }}</p>
                            <span>PAID</span>
                        </div>
                    </div>
                    <div class="body">
                        <table width="100%">
                            <thead>
                                <tr>
                                    <th align="left">SL</th>
                                    <th align="left">Particular</th>
                                    <th align="center">Amount</th>
                                    <th align="right">Discount</th>
                                    <th align="right">Total</th>
                                </tr>
                            </thead>
                            <tbody border-bottom="5">
                                @foreach ($invoice_items as $key => $item)
                                    <tr>
                                        <td align="left">{{ ++$key }}</td>
                                        <td align="left">{{ $feeTypes[$item->fee_type_id] ?? '' }}</td>
                                        <td align="center">{{ $item->amount ?? '' }} Tk</td>
                                        <td align="right">{{ $item->discount ?? '' }} Tk</td>
                                        <td align="right">{{ $item->amount - $item->discount }} Tk</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="foot">
                        <div class="prepared_by">
                            <img src="{{ asset('signature/principal.jpg') }}" height="60px" alt="Signature">
                            {{-- <div class="name">{{ auth()->user()->name }}</div> --}}
                            <div class="name">Signature</div>
                        </div>
                        <div class="content">
                            <p><b>Amount:</b> {{ $invoice->total_amount ?? '' }} Tk</p>
                            <p>Discount: {{ $invoice->total_discount ?? '0' }} Tk</p>
                            <p>Late Fine: {{ $invoice->late_fine ?? '0' }} Tk </p>
                            <p><b>Total Payable:</b>
                                {{ $invoice->total_amount + $invoice->late_fine - $invoice->total_discount }}.00 Tk</p>
                        </div>
                    </div>
                </div>
                <div class="invoice_footer">
                    <div class="powerby">
                        <div class="title_message">Thank you for your payment</div>
                        Powered By <span>EduEasy</span>
                    </div>
                </div>
            </div>
        </div>
    @endif

@endsection
@section('scripts')
    <script>
        // let print_preview = "{{ isset($print_preview) ? $print_preview : '' }}";
        // if (print_preview == 'yes') {
            printInv();
        // }
        function printInv() {
            let htmlToPrint = '';
            // let divToPrint = document.getElementById('invoice');
            let divToPrint = document.getElementsByClassName("invoice_content");

            const newWin = window.open("");

            htmlToPrint = `<style type="text/css" media="print">
                        @page { size: a5; }
                        .invoice_content{
                            visibility: ;
                        }
                        body{
                            font-family: sans-serif;
                            font-style: normal;
                            // max-width: 450px;
                            height: 210mm;
                            width: 148.5mm;
                            margin: 0;
                            -webkit-print-color-adjust: exact;
                        }
                        p{
                            margin-top: 0;
                            margin-bottom: 10px;
                        }
                        .invoice_header .content h2{
                            margin-top: 0;
                            margin-bottom: 12px;
                            font-size: 21px;
                            font-weight: 700;
                        }
                        .invoice_header .content p{
                            margin-bottom: 5px;
                            font-weight: 300;
                            color: #5a5a5a;
                            font-size: 15px;
                        }
                        .invoice_header {
                            display: flex;
                        }
                        .invoice_header .img {
                            width: 35%;
                        }
                        .invoice_header .img img {
                            width: 200px;
                            height: 124px;
                        }
                        .invoice_header .content {
                            color: black;
                            width: 65%;
                        }
                        .invoice_footer .title_message {
                            text-align: center;
                            margin-top: 0;
                            font-family: cursive;
                            color: black;
                            margin-bottom: 7px;
                            font-size: 13px;
                        }
                        .invoice_footer .powerby {
                            color: #747474;
                            font-size: 12px;
                            font-weight: 300;
                            text-align: center;
                            background: #eee;
                            margin-top: 12px;
                            padding: 5px;
                            line-height: 1;
                        }
                        .invoice_footer .powerby span {
                            color: black;
                            letter-spacing: .5px;
                            font-weight: bold;
                        }
                        .invoice_content {
                            width: 100%;
                            max-width: 210mm;
                            margin: 0px auto 2.5em;
                            padding: 20px;
                            border: 1px dotted #ccc;
                            background-color: #fff;
                        }
                        .invoice_body {
                            padding: 20px;
                        }
                        .invoice_body .head {
                            padding: 15px;
                            border: 1px solid #ededed;
                            display: flex;
                            margin-bottom: 8px;
                            background-color: #f5f5f5b8;
                        }
                        .invoice_body .head .left {
                            width: 50%;
                            text-align: left;
                            color: black;
                        }
                        .invoice_body .head .right p, .invoice_body .head .left p {
                            margin-bottom: 7px;
                            margin-top: 0;
                            font-size: 15px;
                        }
                        .invoice_body .head .right {
                            width: 50%;
                            text-align: right;
                            color: black;
                        }
                        .invoice_body .head .right span{
                            font-weight: 700;
                            font-size: 28px;
                            color: #000;
                        }
                        .invoice_body .body table thead {
                            background: #e1e1e1;
                        }
                        .invoice_body .body table thead th:first-child {
                            border-radius: 0 !important;
                        }
                        .invoice_body .body table thead th:nth-child(3),
                        .invoice_body .body table tbody td:nth-child(3) {
                            text-align: center;
                        }
                        .invoice_body .body table thead th:nth-child(4),
                        .invoice_body .body table tbody td:nth-child(4) {
                            text-align: right;
                        }
                        .invoice_body .body table thead th:last-child {
                            border-radius: 0 !important;
                            text-align: right;
                        }
                        .invoice_body .body table thead tr th {
                            border: none;
                            padding: 6px 10px;
                            color: black;
                            line-height: 1;
                        }
                        .invoice_body .body table {
                            margin-bottom: 8px;
                        }
                        .invoice_body .body table tbody tr td {
                            border-top: none;
                            padding: 8px;
                            color: black;
                            border-bottom: 1px solid #e9e9e9;
                        }
                        .invoice_body .foot {
                            display: flex;
                        }
                        .invoice_body .foot .prepared_by {
                            width: 35%;
                            text-align: center;
                            vertical-align: bottom;
                            display: inline-grid;
                        }
                        .invoice_body .foot .prepared_by .name {
                            border-top: 1px solid;
                            color: black;
                        }
                        .invoice_body .foot .content {
                            width: 65%;
                            text-align: right;
                            color: black;
                            padding-right: 10px;
                        }
                        .invoice_body .foot .content p {
                            margin-bottom: 6px;
                            font-size: 14px;
                            color: #4a4a4a;
                        }
                    </style>`;

            newWin.document.write(htmlToPrint);

            newWin.document.write(divToPrint[0].outerHTML);
            newWin.document.close();
            // newWin.print();
            // newWin.close();
            setTimeout(function() {
                newWin.print();
                newWin.close();
            }, 90);
        }
        let printWindowClosed = false;

        function closeWindow() {
            if (!printWindowClosed) {
                printWindowClosed = true;
                window.close();
                if (window.opener) {
                    window.opener.focus();
                }
            }
        }
    </script>
@endsection






















































@extends('layouts.master')
@section('content')

    @if(isset($invoice) && !empty($invoice))
        <div class="card p-1">
            <div class="card-header">
                <div class="row hide-btn">
                    <div class="col col-md-12">

                        <button class="btn btn-success btn-sm" onclick="printDiv('portrait')">
                            Print
                        </button>
                        <hr>
                    </div>
                </div>
            </div>
            <div class="card-body">

                <div class="col-md-12 table_content">


                    <!-- company details content -->
                    <div class="row mb-5">
                        <div class="col-md-12 mt-3">
                            <img src="{{asset('uploads/images/logo-white.jpg')}}" width="100px" height="100px" alt="">

                            <span style="font-size: 40px;font-weight:bold;">Jabalunnur Al-Jamiyatul Ishlamia</span>


                        </div>
                    </div>

                    <!-- customer details content -->
                    <div class="row mb-5">
                        
                        <table class="table">
                            <tbody>
                                <tr>
                                    <th>Name</th>
                                    <td>{{($student_details->first_name ?? "")." ".($student_details->last_name ?? "")}}</td>
                                    <th>Class (Section)</th>
                                    <td>Class 1 (A) </td>
                                </tr>

                                <tr>
                                    <th>Mobile Number</th>
                                    <td>{{$student_details->mobile_no ?? ""}}</td>
                                    <th>Roll Number</th>
                                    <td> {{$student_details->class_roll ?? ""}} </td>
                                </tr>
                                <tr>
                                    <th>Invoice No</th>
                                    <td>{{ $invoice->invoice_no ?? ''}}</td>
                                    <th>Invoice Date</th>
                                    <td>{{ $invoice->invoice_date ?? ""}}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <table class="table table-bordered mt-2 row_add sales_table">
                                <thead>
                                    <tr class="table-secondary">
                                        <th width="5%">SL</th>
                                        <th>Type</th>
                                        <th>Amount</th>
                                        <th>Discount</th>
                                    </tr>
                                </thead>
                                <tbody class="append_row">
                                    @foreach ($invoice_items as $key => $item)
                                        <tr>
                                            <td>{{++$key}}</td>
                                            <td>
                                                {{ $feeTypes[$item->fee_type_id] ?? ""}}
                                            </td>
                                            <td>
                                                {{ $item->amount ?? ""}} ৳
                                            </td>
                                            <td>
                                                {{ $item->discount ?? ""}} ৳
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-4 d-flex">
                            <span class="mt-auto font-weight-bold h1">
                                {{-- Thank you! --}}
                            </span>
                        </div>
                        <div class="col-md-4">
                            {{-- <img src="{{asset('uploads/images/attar_lover_round_logo.jpeg')}}" width="180px" height="180px" alt=""> --}}
                        </div>
                        <div class="col-md-4">
                            <table class="table">
                                <tr>
                                    <td><b>Total Amount </b></td>
                                    <td><b>: {{$invoice->total_amount ?? ""}} ৳</b></td>
                                </tr>
                                <tr>
                                    <td><b>Total Discount</b></td>
                                    <td><b>: {{$invoice->total_discount ?? "0"}} ৳</b> </td>
                                </tr>
                                <tr>
                                    <td><b>Late Fine</b></td>
                                    <td><b>: {{$invoice->late_fine ?? "0"}} ৳</b> </td>
                                </tr>
                                <tr>
                                    <td><b>Final Amount</b></td>
                                    <td><b>: {{ ($invoice->total_amount + $invoice->late_fine) - $invoice->total_discount}}.00 ৳</b> </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 text-right">
                            <img src="{{asset('signature/principal.jpg')}}" width="180px" height="60px" alt="">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12 d-none" id="developed_by" style="bottom: 0;position:fixed;">
                            Developed By : Insaf Solution Ltd. (www.insafsolution.com).
                        </div>
                    </div>
                </div>
            </div>
        </div>

    @endif
@endsection


@section('scripts')
    <script>
        function printInv(){
            var element = document.getElementById("developed_by");

            element.classList.remove("d-none");
            setTimeout(function() {
                element.classList.add("d-none");
                window.print();
                window.close();
            }, 90);

        }
    </script>
@endsection



<!-- show.blade.php file backup code -->
@extends('layouts.master')
@section('content')
    @if(isset($invoice) && !empty($invoice))
    <div class="card p-1">
        <div class="card-header">
            <div class="row hide-btn">
                <div class="col col-md-12">
                    <button class="btn btn-success btn-sm" onclick="printInv()">Print</button>
                    <hr>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="container-fluid p-0">
                <div class="row">
                    <div class="col-12">
                        <div class="invoice-container" id="invoice">
                            <div class="invoice-header">
                                <div class="row">
                                    <div class="col-3">
                                        <img src="{{ asset('uploads/images/logo-white.jpg') }}" width="100px" height="100px" alt="Logo">
                                    </div>
                                    <div class="col-9 text-left">
                                        <h2>Jabalunnur Al-Jamiyatul Ishlamia</h2>
                                        <h4>জাবালুন্নুর আল-জামিয়াতুল ইসলামিয়া</h4>
                                        <p>Address: Dhaka Mirpur 1, Block D, 1216, Bangladesh</p>
                                    </div>
                                </div>
                            </div>
                            <div class="invoice-body">
                                <div class="row">
                                    <div class="col-6">
                                        <h4>Bill To:</h4>
                                        <p>
                                            {{ $student_details->first_name ?? '' }} {{ $student_details->last_name ?? '' }}<br>
                                            {{ $student_details->mobile_no ?? '' }}<br>
                                            Class 1 (A)<br>
                                            Roll No: {{ $student_details->class_roll ?? '' }}
                                        </p>
                                    </div>
                                    <div class="col-6 text-right">
                                        <p>Invoice No: {{ $invoice->invoice_no ?? '' }} </p>
                                        <p>Invoice Date: {{ $invoice->invoice_date ?? '' }}</p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>SL</th>
                                                    <th>Type</th>
                                                    <th>Amount</th>
                                                    <th>Discount</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($invoice_items as $key => $item)
                                                    <tr>
                                                        <td>{{ ++$key }}</td>
                                                        <td>{{ $feeTypes[$item->fee_type_id] ?? '' }}</td>
                                                        <td>{{ $item->amount ?? '' }} ৳</td>
                                                        <td>{{ $item->discount ?? '' }} ৳</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 text-right">
                                        <img src="{{ asset('signature/principal.jpg') }}" width="180px" height="60px" alt="Signature">
                                    </div>
                                    <div class="col-9 text-right">
                                        <p>Total Amount: {{ $invoice->total_amount ?? '' }} ৳ </p>
                                        <p>Total Discount: {{ $invoice->total_discount ?? '0' }} ৳ </p>
                                        <p>Late Fine: {{ $invoice->late_fine ?? '0' }} ৳ </p>
                                        <p>Final Amount: {{ ($invoice->total_amount + $invoice->late_fine) - $invoice->total_discount }}.00 ৳</p>
                                    </div>
                                </div>
                            </div>
                            <div class="invoice-footer">
                                <div class="row">
                                    <div class="col-12 text-right">
                                        <p>Thank you for your payment.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <style>
    .invoice-container {
        width: 100%;
        max-width: 210mm;
        margin: 0 auto;
        padding: 20px;
        border: 1px dotted #ccc;
        background-color: #fff;
    }

    .invoice-header, .invoice-footer {
        background-color: #f7f7f7;
        padding: 15px;
        border-bottom: 1px solid #ccc;
    }

    .invoice-header h2, .invoice-header h4, .invoice-footer p {
        margin: 0;
    }

    .invoice-body {
        padding: 20px;
    }

    .table-bordered th, .table-bordered td {
        border: 1px solid #ccc !important;
    }

    @media print {

        .invoice-container {
            margin: 0;
            border: none;
            background-color: #fff;
        }
        #invoice {
        padding: 20px;
    }
        @page {
            size: A5;
            margin: 0;
        }
        body {
            margin: 0;
        }
    }
    </style>
@endsection
@section('scripts')
@section('scripts')
    <script>
        function printInv() {
            var invoiceContent = document.getElementById('invoice').innerHTML;
            var originalContent = document.body.innerHTML;

            document.body.innerHTML = invoiceContent;
            window.print();
            document.body.innerHTML = originalContent;
            window.location.reload();  // Reload the page to reapply event listeners and JavaScript
        }
    </script>
@endsection
