@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
            <h5>Fee Fine</h5>
            @can('accounting.fees-type.create')
                <button class="btn btn-light-blue mb-2" data-toggle="modal" data-target="#createModal">Add New</button>
            @endcan
        </div>
        <div class="card-body">

            <div class="row">
                <div class="table-responsive">
                    <table class="table" id="dataTable">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Title</th>
                                <th>Code</th>
                                <th>Description</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                            @php
                                $sn = 0;
                            @endphp
                            @foreach ($feeTypes as $feeType)
                                <tr>
                                    <td>{{ ++$sn }}</td>
                                    <td>{{ $feeType->title }}</td>
                                    <td>{{ $feeType->code }}</td>
                                    <td>{{ $feeType->description ?? '--' }}</td>
                                    <td>
                                        @can('accounting.fees-type.edit')
                                            @if ($feeType->code=="TUITION")
                                                <button class="btn btn-primary btn-sm" title="This item is not editable" disabled>Edit</button>
                                            @else
                                                <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#editModal{{ $feeType->id }}">Edit</button>
                                            @endif
                                        @endcan
                                        @can('accounting.fees-type.delete')
                                            @if ($feeType->code=="TUITION")
                                                <button type="submit" class="btn btn-danger btn-sm" disabled>Delete</button>
                                            @else
                                                <form action="{{ route('fee_types.destroy', $feeType->id) }}"
                                                    method="POST" style="display:inline-block;"
                                                    onsubmit="return confirm('Are you sure you want to delete this')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                                </form>
                                            @endif
                                        @endcan
                                    </td>
                                </tr>
                                <!-- Edit Modal -->
                                <div class="modal fade" id="editModal{{ $feeType->id }}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel{{ $feeType->id }}" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="editModalLabel{{ $feeType->id }}">Edit Fee Category</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route('fee_types.update', $feeType->id) }}" method="POST">
                                                    @csrf
                                                    @method('PUT')
                                                    <div class="form-group">
                                                        <label for="title">Title</label>
                                                        <input type="text" name="title" class="form-control" value="{{ $feeType->title }}" required>
                                                    </div>
                                                    {{-- <div class="form-group">
                                                        <label for="code">Code</label>
                                                        <input type="text" name="code" class="form-control" value="{{ $feeType->code }}" required>
                                                    </div> --}}
                                                    <div class="form-group">
                                                        <label for="description">Description</label>
                                                        <textarea name="description" class="form-control">{{ $feeType->description }}</textarea>
                                                    </div>
                                                    <button type="submit" class="btn btn-primary">Save changes</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>


            <!-- Create Modal -->
            <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="createModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="createModalLabel">Create Fee Category</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form action="{{ route('fee_types.store') }}" method="POST">
                                @csrf
                                <div class="form-group">
                                    <label for="title">Title</label>
                                    <input type="text" name="title" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label for="code">Code <i class="fas fa-question-circle" data-container="body" data-toggle="popover"
                                        data-placement="right" data-content="Example: For 'Examination Fee' code will be like EXAM."></i></label>
                                    <input type="text" name="code" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label for="description">Description (Optional)</label>
                                    <textarea name="description" class="form-control"></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary">Create</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
