@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        <div class="card">
            <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6>Fee Type</h6>
                @can('accounting.fees-type.create')
                    <button class="btn btn-sm btn-light-blue" data-toggle="modal" data-target="#createModal">Add New</button>
                @endcan
            </div>
            <div class="row">

                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table" id="dataTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $sn = 0;
                                @endphp
                                @foreach ($feeTypes as $feeType)
                                    <tr>
                                        <td>{{ ++$sn }}</td>
                                        <td>{{ $feeType->title }}</td>
                                        <td>
                                            @can('accounting.fees-type.edit')
                                                <button class="btn btn-sm btn-soft-info mr-1" data-toggle="modal" data-target="#editModal{{ $feeType->id }}"><i class="fas fa-edit"></i></button>
                                            @endcan
                                            @can('accounting.fees-type.delete')
                                                <form action="{{ route('fee_types.destroy', $feeType->id) }}"
                                                    method="POST" style="display:inline-block;"
                                                    onsubmit="return confirm('Are you sure you want to delete this')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                                </form>
                                            @endcan
                                        </td>
                                    </tr>
                                    <!-- Edit Modal -->
                                    <div class="modal fade" id="editModal{{ $feeType->id }}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel{{ $feeType->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editModalLabel{{ $feeType->id }}">Edit Fee Type</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <form action="{{ route('fee_types.update', $feeType->id) }}" method="POST">
                                                        @csrf
                                                        @method('PUT')
                                                        <div class="form-group">
                                                            <label for="title">Name <span class="text-danger">*</span></label>
                                                            <input type="text" name="title" class="form-control" value="{{ $feeType->title }}" required>
                                                        </div>

                                                        {{--<div class="form-group">
                                                            {{ generateDropdown(Accounting::FEE_TYPES, 'class="form-control select2" name="code" required', $feeType->code, "") }}
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="code">Will be applied in month <span class="text-danger">*</span></label>
                                                            {{ generateDropdown($months, 'class="form-control select2" name="month" required', $feeType->month, "Select Month") }}
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="description">Description</label>
                                                            <textarea name="description" class="form-control">{{ $feeType->description }}</textarea>
                                                        </div>--}}
                                                        <button type="submit" class="btn btn-submit">Update</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Create Modal -->
                <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="createModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="createModalLabel">Create Fee Type</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <form action="{{ route('fee_types.store') }}" method="POST">
                                    @csrf
                                    <div class="form-group">
                                        <label for="title">Name <span class="text-danger">*</span></label>
                                        <input type="text" name="title" class="form-control" required>
                                    </div>

                                    {{--<div class="form-group">
                                        <label for="code">Type
                                            <i class="fas fa-question-circle popover-icon"
                                                data-container="body"
                                                data-toggle="popover"
                                                data-placement="right"
                                                data-content="Example: For 'Examination Fee' Type will be EXAM.">
                                            </i>
                                        </label>
                                        {{ generateDropdown(Accounting::FEE_TYPES, 'class="form-control select2" name="code" required', '', "") }}
                                    </div>
                                    <div class="form-group">
                                        <label for="code">Will be applied in month <span class="text-danger">*</span></label>
                                        {{ generateDropdown($months, 'class="form-control select2" name="month" required', '', "Select Month") }}
                                    </div>
                                    <div class="form-group">
                                        <label for="description">Description (Optional)</label>
                                        <textarea name="description" class="form-control"></textarea>
                                    </div> --}}
                                    <button type="submit" class="btn btn-submit">Submit</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop
